/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.magnoliastripes;

import info.magnolia.module.templating.Paragraph;
import info.magnolia.module.templating.ParagraphManager;
import it.openutils.magnoliastripes.StripesModule;
import it.openutils.magnoliastripes.annotations.Dialog;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.controller.NameBasedActionResolver;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MgnlActionResolver
extends NameBasedActionResolver {
    private static Logger log = LoggerFactory.getLogger(MgnlActionResolver.class);
    private static Set<Paragraph> paragraphs = new HashSet<Paragraph>();

    protected void addActionBean(Class<? extends ActionBean> clazz) {
        String binding = this.getUrlBinding(clazz);
        if (binding != null) {
            String paragraphName = this.actionNameToParagraphName(binding);
            String dialogName = this.annotationDialogToParagraphName(clazz);
            if (StringUtils.isBlank((String)dialogName)) {
                dialogName = paragraphName;
            }
            this.collectStripesParagraphs(paragraphName, dialogName, binding);
            super.addActionBean(clazz);
        }
    }

    protected String annotationDialogToParagraphName(Class<? extends ActionBean> clazz) {
        return this.processDialogAnnotation(clazz);
    }

    protected String processDialogAnnotation(Class<? extends ActionBean> clazz) {
        Dialog annotation = clazz.getAnnotation(Dialog.class);
        if (annotation == null) {
            return null;
        }
        String pattern = annotation.value();
        if (StringUtils.isBlank((String)pattern)) {
            return null;
        }
        return pattern;
    }

    protected String actionNameToParagraphName(String binding) {
        String dialogName = StringUtils.lowerCase((String)StringUtils.substringBeforeLast((String)StringUtils.substringAfterLast((String)binding, (String)"/"), (String)"."));
        return dialogName;
    }

    private void collectStripesParagraphs(String paragraphName, String dialogName, String binding) {
        Paragraph paragraph = new Paragraph();
        paragraph.setName(paragraphName);
        paragraph.setTitle("paragraph." + paragraphName + ".title");
        paragraph.setDescription("paragraph." + paragraphName + ".description");
        paragraph.setDialog(dialogName);
        paragraph.setTemplatePath(binding);
        paragraph.setType("stripes");
        paragraph.setI18nBasename(StripesModule.getInstance().getI18nbasename());
        paragraphs.add(paragraph);
        log.info("Registering stripes paragraph {} with dialog {}", (Object)paragraph.getName(), (Object)paragraph.getDialog());
        ParagraphManager.getInstance().getParagraphs().put(paragraph.getName(), paragraph);
    }

    public static void registerParagraphs() {
        for (Paragraph paragraph : paragraphs) {
            log.info("Registering stripes paragraph {}", (Object)paragraph.getName());
            ParagraphManager.getInstance().getParagraphs().put(paragraph.getName(), paragraph);
        }
    }

    public static Set<Paragraph> getParagraphs() {
        return paragraphs;
    }
}

