/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.magnoliastripes;

import info.magnolia.cms.beans.runtime.Document;
import info.magnolia.cms.beans.runtime.MultipartForm;
import info.magnolia.context.MgnlContext;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.controller.FileUploadLimitExceededException;
import net.sourceforge.stripes.controller.multipart.MultipartWrapper;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MagnoliaMultipartWrapper
implements MultipartWrapper {
    public void build(HttpServletRequest request, File tempDir, long maxPostSize) throws IOException, FileUploadLimitExceededException {
    }

    private MultipartForm getForm() {
        return (MultipartForm)MgnlContext.getAttribute((String)"multipartform", (int)1);
    }

    public Enumeration<String> getParameterNames() {
        return this.getForm().getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.getForm().getParameterValues(name);
    }

    public Enumeration<String> getFileParameterNames() {
        return new IteratorEnumeration(this.getForm().getDocuments().keySet().iterator());
    }

    public FileBean getFileParameterValue(String name) {
        final Document item = this.getForm().getDocument(name);
        if (item == null) {
            return null;
        }
        return new FileBean(null, item.getType(), item.getFileNameWithExtension()){

            public long getSize() {
                return item.getLength();
            }

            public InputStream getInputStream() throws IOException {
                return item.getStream();
            }

            public void save(File toFile) throws IOException {
                BufferedOutputStream os = null;
                InputStream is = null;
                try {
                    os = new BufferedOutputStream(new FileOutputStream(toFile));
                    is = item.getStream();
                    IOUtils.copyLarge((InputStream)is, (OutputStream)os);
                    this.delete();
                }
                catch (Exception e) {
                    try {
                        if (e instanceof IOException) {
                            throw (IOException)e;
                        }
                        IOException ioe = new IOException("Problem saving uploaded file.");
                        ioe.initCause(e);
                        throw ioe;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        IOUtils.closeQuietly(os);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((OutputStream)os);
            }

            public void delete() throws IOException {
                item.delete();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IteratorEnumeration
    implements Enumeration<String> {
        Iterator<String> iterator;

        IteratorEnumeration(Iterator<String> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public String nextElement() {
            return this.iterator.next();
        }
    }
}

