/**
 *
 * Stripes module for Magnolia CMS (http://www.openmindlab.com/lab/products/mgnlstripes.html)
 * Copyright(C) 2008-2011, Openmind S.r.l. http://www.openmindonline.it
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package it.openutils.magnoliastripes.setup;

import info.magnolia.cms.beans.config.ContentRepository;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.ItemType;
import info.magnolia.module.DefaultModuleVersionHandler;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AddMimeMappingTask;
import info.magnolia.module.delta.FilterOrderingTask;
import info.magnolia.module.delta.MoveAndRenamePropertyTask;
import info.magnolia.module.delta.PropertyExistsDelegateTask;
import info.magnolia.module.delta.Task;
import info.magnolia.module.model.Version;
import it.openutils.mgnltasks.CreateMissingPropertyTask;

import java.util.List;

import javax.jcr.RepositoryException;


/**
 * @author fgiust
 * @version $Id: $
 */
public class StripesModuleVersionHandler extends DefaultModuleVersionHandler
{

    /**
     * {@inheritDoc}
     */
    @Override
    protected List<Task> getBasicInstallTasks(InstallContext installContext)
    {
        List<Task> tasks = super.getBasicInstallTasks(installContext);

        tasks.add(new AddMimeMappingTask("action", "text/plain", "/.resources/file-icons/htm.png"));

        tasks.add(new CreateMissingPropertyTask(
            "Adding property: /modules/stripes/config/i18nbasename",
            "Adding property: /modules/stripes/config/i18nbasename",
            ContentRepository.CONFIG,
            "/modules/stripes/config",
            "i18nbasename",
            "it.openutils.magnoliastripes"));

        tasks.add(new FilterOrderingTask(
            "stripes",
            new String[]{"context", "login", "uriSecurity", "multipartRequest" }));

        // Didn't find a better way to get the current magnolia version...
        Content coreModule;
        try
        {
            coreModule = installContext
                .getConfigHierarchyManager()
                .getContent("/modules/core", false, ItemType.CONTENT);
            if ((coreModule != null) && (coreModule.hasNodeData("version")))
            {
                Version coreVersion = Version.parseVersion(coreModule.getNodeData("version").getString());
                // Any version from 4.4.0 onward need this patch.
                if (coreVersion.isStrictlyAfter(Version.parseVersion(4, 3, 99)))
                {
                    tasks.add(new PropertyExistsDelegateTask(
                        "Checking stripes renderer status",
                        "Checking stripes module template renderers status",
                        ContentRepository.CONFIG,
                        "/modules/stripes/template-renderers/stripes",
                        "class",
                        new MoveAndRenamePropertyTask(
                            "Moving strieps renderer \"class\" to \"renderer\"",
                            "/modules/stripes/template-renderers/stripes",
                            "class",
                            "/modules/stripes/template-renderers/stripes",
                            "renderer")));
                    tasks.add(new PropertyExistsDelegateTask(
                        "Checking stripes renderer status",
                        "Checking stripes module template renderers status",
                        ContentRepository.CONFIG,
                        "/modules/stripes/template-renderers/stripes",
                        "name",
                        new MoveAndRenamePropertyTask(
                            "Moving strieps renderer \"name\" to \"type\"",
                            "/modules/stripes/template-renderers/stripes",
                            "name",
                            "/modules/stripes/template-renderers/stripes",
                            "type")));
                }

            }
        }
        catch (RepositoryException e)
        {

            log.error("Unable to check the current magnolia version: {}", e.getMessage());
        }

        return tasks;
    }
}
