/**
 * Copyright Openmind http://www.openmindonline.it
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package it.openutils.magnoliastripes;

import info.magnolia.cms.filters.MgnlFilter;
import info.magnolia.context.MgnlContext;
import info.magnolia.context.WebContext;
import info.magnolia.voting.Voter;
import info.magnolia.voting.Voting;

import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.controller.StripesRequestWrapper;
import net.sourceforge.stripes.exception.StripesServletException;

import org.apache.commons.lang.ArrayUtils;


/**
 * @author fgiust
 * @version $Id: StripesMagnoliaFilter.java 784 2008-04-27 20:42:00Z fgiust $
 */
public class StripesMagnoliaFilter extends StripesFilter implements MgnlFilter
{

    private String name;

    private Voter[] bypasses = new Voter[0];

    private boolean enabled = true;

    public boolean bypasses(HttpServletRequest request)
    {
        if (!isEnabled())
        {
            return true;
        }
        if (MgnlContext.hasInstance())
        {
            return Voting.Factory.getDefaultVoting().vote(bypasses, request) > 0;
        }
        return false;
    }

    public Voter[] getBypasses()
    {
        return this.bypasses;
    }

    public void addBypass(Voter voter)
    {
        this.bypasses = (Voter[]) ArrayUtils.add(this.bypasses, voter);
    }

    public String getName()
    {
        return this.name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public boolean isEnabled()
    {
        return this.enabled;
    }

    public void setEnabled(boolean enabled)
    {
        this.enabled = enabled;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void init(FilterConfig filterConfig) throws ServletException
    {
        super.init(filterConfig);
        filterConfig.getServletContext().setAttribute(Configuration.class.getName(), getInstanceConfiguration());
    }

    /**
     * Wraps the HttpServletRequest with a StripesServletRequest. This is done to ensure that any form posts that
     * contain file uploads get handled appropriately.
     * @param servletRequest the HttpServletRequest handed to the dispatcher by the container
     * @return an instance of StripesRequestWrapper, which is an HttpServletRequestWrapper
     * @throws StripesServletException if the wrapper cannot be constructed
     */
    @Override
    protected StripesRequestWrapper wrapRequest(HttpServletRequest servletRequest) throws StripesServletException
    {
        StripesRequestWrapper srw = new StripesRequestWrapper(servletRequest);

        if (MgnlContext.hasInstance())
        {
            // be sure that the request wrapper gets setted in mgnlcontext too
            WebContext webContext = (WebContext) MgnlContext.getInstance();
            webContext.init(servletRequest, webContext.getResponse(), webContext.getServletContext());
        }

        return srw;
    }

}
