/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.List;
import org.apache.jackrabbit.core.query.lucene.ConsistencyCheck;
import org.apache.jackrabbit.core.query.lucene.MultiIndex;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexUtils {
    private final SearchIndex searchIndex;
    private static Logger log = LoggerFactory.getLogger(IndexUtils.class);

    public IndexUtils(SearchIndex searchIndex) {
        this.searchIndex = searchIndex;
    }

    public void runConsistencyCheck(boolean fix) throws IOException {
        MultiIndex index = this.searchIndex.getIndex();
        ConsistencyCheck check = index.runConsistencyCheck();
        List errors = check.getErrors();
        log.info("Error detected: {}", (Object)errors.size());
        if (fix) {
            check.repair(true);
        }
    }
}

