/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlrepoutils;

import info.magnolia.cms.util.AlertUtil;
import info.magnolia.context.MgnlContext;
import info.magnolia.module.admininterface.TemplatedMVCHandler;
import info.magnolia.objectfactory.Components;
import info.magnolia.repository.RepositoryManager;
import info.magnolia.repository.definition.WorkspaceMappingDefinition;
import it.openutils.mgnlutils.util.NodeUtilsExt;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.query.QueryManagerImpl;
import org.apache.jackrabbit.core.query.lucene.IndexUtils;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;

public class RepositoryUtilsPage
extends TemplatedMVCHandler {
    private String[] repos;

    public RepositoryUtilsPage(String name, HttpServletRequest request, HttpServletResponse response) {
        super(name, request, response);
    }

    public String[] getRepos() {
        return this.repos;
    }

    public void setRepos(String[] repos) {
        this.repos = repos;
    }

    public Iterator<String> getRepositories() {
        return ((RepositoryManager)Components.getComponent(RepositoryManager.class)).getWorkspaceNames().iterator();
    }

    public String doIndexConsistencyFix() throws Exception {
        if (this.repos == null) {
            AlertUtil.setMessage((String)"Please select one or more workspaces");
            return this.show();
        }
        for (String repo : this.repos) {
            IndexUtils iu = new IndexUtils(this.getSearchIndex(repo));
            iu.runConsistencyCheck(true);
        }
        AlertUtil.setMessage((String)("Index consistency check done on " + ArrayUtils.toString((Object)this.repos)));
        return this.show();
    }

    public String doPmCheck() throws Exception {
        if (this.repos == null) {
            AlertUtil.setMessage((String)"Please select one or more workspaces");
            return this.show();
        }
        for (String repo : this.repos) {
            PersistenceManager pm = this.getPersistenceManager(repo);
            pm.checkConsistency(null, true, true);
        }
        AlertUtil.setMessage((String)("Persistence manager check done on " + ArrayUtils.toString((Object)this.repos)));
        return this.show();
    }

    private Object getPropertyUsingReflection(Object object, String property) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = object.getClass().getDeclaredMethod("get" + StringUtils.capitalize((String)property), new Class[0]);
        method.setAccessible(true);
        return method.invoke(object, new Object[0]);
    }

    private SearchIndex getSearchIndex(String repo) throws RepositoryException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        WorkspaceImpl workspace = (WorkspaceImpl)NodeUtilsExt.unwrap((Workspace)MgnlContext.getJCRSession((String)repo).getWorkspace());
        QueryManagerImpl queryManager = (QueryManagerImpl)workspace.getQueryManager();
        SearchIndex searchIndex = (SearchIndex)this.getPropertyUsingReflection(queryManager, "queryHandler");
        return searchIndex;
    }

    private PersistenceManager getPersistenceManager(String repo) throws Exception {
        WorkspaceImpl workspace = (WorkspaceImpl)NodeUtilsExt.unwrap((Workspace)MgnlContext.getJCRSession((String)repo).getWorkspace());
        Repository repository = workspace.getSession().getRepository();
        WorkspaceMappingDefinition mapping = ((RepositoryManager)Components.getComponent(RepositoryManager.class)).getWorkspaceMapping(repo);
        String workspaceName = mapping != null ? mapping.getPhysicalWorkspaceName() : repo;
        return this.getPM(repository, workspaceName);
    }

    private PersistenceManager getPM(Repository repository, String workspaceName) throws Exception {
        if (workspaceName == null || workspaceName.equals("version")) {
            Object versionManager = this.findMethodByName(repository, "getVersionManager", null);
            Field f = versionManager.getClass().getDeclaredField("pMgr");
            f.setAccessible(true);
            return (PersistenceManager)f.get(versionManager);
        }
        Object workspaceInfo = this.findMethodByName(repository, "getWorkspaceInfo", new Object[]{workspaceName});
        return (PersistenceManager)this.findMethodByName(workspaceInfo, "getPersistenceManager", null);
    }

    private Object findMethodByName(Object obj, String name, Object[] parameters) throws Exception {
        Method m = null;
        Method[] ms = obj.getClass().getDeclaredMethods();
        for (int i = 0; i < ms.length; ++i) {
            Method x = ms[i];
            if (!x.getName().equals(name)) continue;
            m = x;
            break;
        }
        m.setAccessible(true);
        return m.invoke(obj, parameters);
    }
}

