/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlrepoutils;

import info.magnolia.cms.util.AlertUtil;
import info.magnolia.context.MgnlContext;
import info.magnolia.module.admininterface.TemplatedMVCHandler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.openutils.mgnlrepoutils.Linkfix;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkfixPage
extends TemplatedMVCHandler {
    private static Logger log = LoggerFactory.getLogger(LinkfixPage.class);
    private static final String SUCCESS = "success";
    private String replacements;
    private String sourceRepositoriesAndPaths;
    private String targetRepositories;

    public LinkfixPage(String name, HttpServletRequest request, HttpServletResponse response) {
        super(name, request, response);
    }

    public void setReplacements(String replacements) {
        this.replacements = replacements;
    }

    public void setSourceRepositoriesAndPaths(String sourceRepositoriesAndPaths) {
        this.sourceRepositoriesAndPaths = sourceRepositoriesAndPaths;
    }

    public void setTargetRepositories(String targetRepositories) {
        this.targetRepositories = targetRepositories;
    }

    public String getReplacements() {
        return this.replacements;
    }

    public String getSourceRepositoriesAndPaths() {
        return this.sourceRepositoriesAndPaths;
    }

    public String getTargetRepositories() {
        return this.targetRepositories;
    }

    public String execute() throws RepositoryException {
        String[] replacementsSplit = StringUtils.split((String)this.replacements, (String)"\n");
        LinkedHashMap<String, String> replacementsMap = new LinkedHashMap<String, String>();
        for (String string : replacementsSplit) {
            String[] split = StringUtils.split((String)StringUtils.trim((String)string), (String)"=");
            if (!(split != null & split.length > 1)) continue;
            replacementsMap.put(split[0], split[1]);
        }
        String[] sourceRepositoriesAndPathsArray = StringUtils.split((String)StringUtils.trim((String)this.sourceRepositoriesAndPaths), (String)"\n");
        ArrayList<String> sourceRepositoriesAndPathList = new ArrayList<String>();
        for (String string : sourceRepositoriesAndPathsArray) {
            if (StringUtils.contains((String)string, (String)":")) {
                sourceRepositoriesAndPathList.add(StringUtils.trim((String)string));
                continue;
            }
            log.error("Invalid path: {}", (Object)string);
        }
        String[] repoArray = StringUtils.split((String)this.targetRepositories);
        ArrayList<String> reposAsList = new ArrayList<String>();
        for (String string : repoArray) {
            String repo = StringUtils.trim((String)string);
            if (!StringUtils.isNotEmpty((String)repo)) continue;
            try {
                MgnlContext.getJCRSession((String)repo);
            }
            catch (IllegalArgumentException e) {
                log.error(e.getMessage(), (Throwable)e);
                AlertUtil.setMessage((String)String.format("Invalid repository: %s", repo));
                return SUCCESS;
            }
            reposAsList.add(repo);
        }
        StopWatch sw = new StopWatch();
        sw.start();
        Linkfix linkfix = new Linkfix(replacementsMap, sourceRepositoriesAndPathList, reposAsList);
        try {
            linkfix.process();
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            AlertUtil.setMessage((String)(e.getClass().getName() + ": " + StringUtils.defaultIfEmpty((String)e.getMessage(), (String)"(no message)")));
            return SUCCESS;
        }
        sw.stop();
        long time = sw.getTime();
        AlertUtil.setMessage((String)String.format("Fix done in %s, %s nodes processed, %s matches and %s substitutions applied. Full list of modified properties:\n%s", DurationFormatUtils.formatDurationWords((long)time, (boolean)true, (boolean)false), linkfix.getNodesCount(), linkfix.getMatchesCount(), linkfix.getSubstitutionsCount(), StringUtils.defaultIfEmpty((String)linkfix.getFullLog(), (String)"(none)")));
        return SUCCESS;
    }
}

