/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlrepoutils;

import info.magnolia.context.MgnlContext;
import info.magnolia.jcr.util.MetaDataUtil;
import info.magnolia.jcr.util.NodeUtil;
import it.openutils.mgnlutils.util.NodeUtilsExt;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResultItem;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.JCRCriteriaFactory;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Criterion;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Restrictions;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.commons.predicate.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Linkfix {
    private static final Pattern UUID_PATTERN = Pattern.compile("([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})");
    private Map<String, String> replacements;
    private Collection<String> sourceRepositoriesAndPaths;
    private Collection<String> targetRepositories;
    private int nodesCount;
    private int matchesCount;
    private int substitutionsCount;
    private StringWriter fullLog = new StringWriter();
    private Logger log = LoggerFactory.getLogger(Linkfix.class);

    public Linkfix(Map<String, String> replacements, Collection<String> sourceRepositoriesAndPaths, Collection<String> targetRepositories) {
        this.replacements = replacements;
        this.sourceRepositoriesAndPaths = sourceRepositoriesAndPaths;
        this.targetRepositories = targetRepositories;
    }

    public int getMatchesCount() {
        return this.matchesCount;
    }

    public int getNodesCount() {
        return this.nodesCount;
    }

    public int getSubstitutionsCount() {
        return this.substitutionsCount;
    }

    public String getFullLog() {
        return this.fullLog.toString();
    }

    public void process() throws RepositoryException {
        this.log.info("Starting");
        for (String source : this.sourceRepositoriesAndPaths) {
            String repo = StringUtils.substringBefore((String)source, (String)":");
            String path = StringUtils.substringAfter((String)source, (String)":");
            if (StringUtils.isEmpty((String)repo) || StringUtils.isEmpty((String)path)) {
                this.log.error("Skipping entry {}, must be in \"repo:path\" format", (Object)source);
                continue;
            }
            this.log.info("Processing {}", (Object)source);
            Node node = MgnlContext.getJCRSession((String)repo).getNode(path);
            this.processNode(node);
        }
        this.log.info("Everything done");
    }

    private void processNode(Node node) throws RepositoryException {
        this.log.debug("Processing {}", (Object)NodeUtil.getPathIfPossible((Node)node));
        ++this.nodesCount;
        PropertyIterator properties = node.getProperties();
        boolean nodeUpdated = false;
        while (properties.hasNext()) {
            nodeUpdated = this.processProperty(properties.nextProperty()) || nodeUpdated;
        }
        if (nodeUpdated) {
            MetaDataUtil.updateMetaData((Node)node);
        }
        Iterable children = NodeUtil.getNodes((Node)node, (Predicate)NodeUtil.EXCLUDE_META_DATA_FILTER);
        for (Node child : children) {
            this.processNode(child);
        }
    }

    private boolean processProperty(Property data) throws RepositoryException {
        if (data.isMultiple()) {
            return this.processMultiValue(data);
        }
        if (data.getType() == 1) {
            return this.processString(data);
        }
        return false;
    }

    private boolean processString(Property data) throws RepositoryException {
        String dataAsString = data.getString();
        if (StringUtils.isEmpty((String)dataAsString)) {
            return false;
        }
        boolean gotMatches = false;
        Matcher matcher = UUID_PATTERN.matcher(dataAsString);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            ++this.matchesCount;
            String uuid = matcher.group(0);
            String newuuid = this.findAndReplaceUuid(uuid);
            if (newuuid == null) continue;
            this.log.debug("Replacing UUID {} with {}", (Object)uuid, (Object)newuuid);
            this.fullLog.append(String.format("%s:%s\n", data.getSession().getWorkspace().getName(), data.getPath()));
            gotMatches = true;
            ++this.substitutionsCount;
            matcher.appendReplacement(sb, newuuid);
        }
        matcher.appendTail(sb);
        String newString = sb.toString();
        for (Map.Entry<String, String> repl : this.replacements.entrySet()) {
            Pattern pattern = Pattern.compile(repl.getKey());
            matcher = pattern.matcher(newString);
            sb = new StringBuffer();
            while (matcher.find()) {
                ++this.matchesCount;
                String plainpath = matcher.group(0);
                this.log.debug("Replacing text {} with {}", (Object)plainpath, (Object)repl.getValue());
                this.fullLog.append(String.format("%s:%s\n", data.getSession().getWorkspace().getName(), data.getPath()));
                gotMatches = true;
                ++this.substitutionsCount;
                matcher.appendReplacement(sb, repl.getValue());
            }
            matcher.appendTail(sb);
            newString = sb.toString();
        }
        if (gotMatches) {
            data.setValue(newString);
            data.getSession().save();
            return true;
        }
        return false;
    }

    private String findAndReplaceUuid(String uuid) {
        for (String repo : this.targetRepositories) {
            AdvancedResultItem result = JCRCriteriaFactory.createCriteria().setWorkspace(repo).add((Criterion)Restrictions.eq((String)"jcr:uuid", (Object)uuid)).execute().getFirstResult();
            if (result == null) continue;
            String handle = result.getHandle();
            this.log.debug("Found uuid {} in repo {} with handle {}", new Object[]{uuid, repo, handle});
            for (Map.Entry<String, String> replacement : this.replacements.entrySet()) {
                if (!StringUtils.contains((String)handle, (String)replacement.getKey())) continue;
                String newhandle = StringUtils.replace((String)handle, (String)replacement.getKey(), (String)replacement.getValue());
                try {
                    Node newcontent = NodeUtilsExt.getNodeIfExists((Session)MgnlContext.getJCRSession((String)repo), (String)newhandle);
                    if (newcontent == null) continue;
                    return NodeUtil.getNodeIdentifierIfPossible((Node)newcontent);
                }
                catch (RepositoryException e) {
                }
            }
        }
        return null;
    }

    private boolean processMultiValue(Property data) throws RepositoryException {
        Value[] values = data.getValues();
        boolean gotMatches = false;
        for (int j = 0; j < values.length; ++j) {
            Value value = values[j];
            String dataAsString = value.getString();
            boolean gotValueMatches = false;
            Matcher matcher = UUID_PATTERN.matcher(dataAsString);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                ++this.matchesCount;
                String uuid = matcher.group(0);
                String newuuid = this.findAndReplaceUuid(uuid);
                if (newuuid != null) {
                    this.log.debug("Replacing UUID {} with {} (multivalue)", (Object)uuid, (Object)newuuid);
                    gotMatches = true;
                    gotValueMatches = true;
                    ++this.substitutionsCount;
                    matcher.appendReplacement(sb, newuuid);
                    continue;
                }
                matcher.appendTail(sb);
            }
            if (!gotValueMatches) continue;
            matcher.appendTail(sb);
            String newString = sb.toString();
            this.log.info("Creating value {}", (Object)newString);
            values[j] = data.getSession().getWorkspace().getSession().getValueFactory().createValue(newString);
        }
        if (gotMatches) {
            this.log.debug("Setting value {} {}", (Object)values.length, (Object)values);
            data.setValue(values);
            data.getSession().save();
            return true;
        }
        return false;
    }
}

