/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.playlist.utils;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.context.MgnlContext;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResult;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResultItem;
import net.sourceforge.openutils.mgnlmedia.media.pages.SortMode;
import net.sourceforge.openutils.mgnlmedia.media.tags.el.MediaEl;
import net.sourceforge.openutils.mgnlmedia.playlist.PlaylistConstants;
import org.apache.commons.collections.IteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlaylistIterateUtils {
    private static Logger log = LoggerFactory.getLogger(PlaylistIterateUtils.class);

    private PlaylistIterateUtils() {
    }

    public static Iterator<MediaNodeAndEntryPath> iterate(final Content playlistNode) {
        if (playlistNode == null) {
            return IteratorUtils.emptyIterator();
        }
        try {
            if (playlistNode.hasContent("search")) {
                Content searchNode = playlistNode.getContent("search");
                Collection paramNodes = searchNode.getChildren(ItemType.CONTENTNODE);
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (Content paramNode : paramNodes) {
                    String paramName = NodeDataUtil.getString((Content)paramNode, (String)"name");
                    Value[] jcrValues = paramNode.getNodeData("value").getValues();
                    String[] paramValues = new String[jcrValues.length];
                    for (int i = 0; i < jcrValues.length; ++i) {
                        paramValues[i] = jcrValues[i].getString();
                    }
                    if (paramValues.length == 1) {
                        map.put(paramName, paramValues[0]);
                        continue;
                    }
                    if (paramValues.length <= 1) continue;
                    map.put(paramName, paramValues);
                }
                AdvancedResult searchResult = MediaEl.module().getSearch().search((HttpServletRequest)new CustomParamsRequest(MgnlContext.getWebContext().getRequest(), map, false), null, "/", true, SortMode.SCORE, (int)NodeDataUtil.getLong((Content)playlistNode, (String)"maxResults", (long)0L), 1);
                return Iterators.transform((Iterator)searchResult.getItems(), (Function)new Function<AdvancedResultItem, MediaNodeAndEntryPath>(){

                    public MediaNodeAndEntryPath apply(AdvancedResultItem from) {
                        return new MediaNodeAndEntryPath((Content)from, null);
                    }
                });
            }
            return Iterators.transform(playlistNode.getChildren(PlaylistConstants.PLAYLIST_ENTRY).iterator(), (Function)new Function<Content, MediaNodeAndEntryPath>(){

                public MediaNodeAndEntryPath apply(Content playlistEntry) {
                    String mediaUUID = NodeDataUtil.getString((Content)playlistEntry, (String)"media");
                    Content mediaNode = MediaEl.node(mediaUUID);
                    if (mediaNode == null) {
                        log.warn("Node {} referenced by entry {} of playlist {} does not exist in media repository", new Object[]{mediaUUID, playlistEntry.getName(), playlistNode.getHandle()});
                    }
                    return new MediaNodeAndEntryPath(mediaNode, playlistEntry.getHandle());
                }
            });
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    private static final class CustomParamsRequest
    extends HttpServletRequestWrapper {
        private final HashMap paramsMap;

        private CustomParamsRequest(HttpServletRequest request, Map paramMap, boolean inheritParams) {
            super(request);
            this.paramsMap = inheritParams ? new HashMap(request.getParameterMap()) : new HashMap();
            for (Map.Entry entry : paramMap.entrySet()) {
                int el;
                int i;
                String[] valueArray;
                String name = String.valueOf(entry.getKey());
                Object value = entry.getValue();
                if (value == null) {
                    valueArray = new String[]{null};
                } else if (value instanceof String[]) {
                    valueArray = (String[])value;
                } else if (value instanceof Collection) {
                    Collection col = (Collection)value;
                    valueArray = new String[col.size()];
                    i = 0;
                    Iterator it2 = col.iterator();
                    while (it2.hasNext()) {
                        valueArray[i++] = String.valueOf(it2.next());
                    }
                } else if (value.getClass().isArray()) {
                    int len = Array.getLength(value);
                    valueArray = new String[len];
                    for (i = 0; i < len; ++i) {
                        valueArray[i] = String.valueOf(Array.get(value, i));
                    }
                } else {
                    valueArray = new String[]{String.valueOf(value)};
                }
                String[] existingParams = (String[])this.paramsMap.get(name);
                int n = el = existingParams == null ? 0 : existingParams.length;
                if (el == 0) {
                    this.paramsMap.put(name, valueArray);
                    continue;
                }
                int vl = valueArray.length;
                if (vl <= 0) continue;
                String[] newValueArray = new String[el + vl];
                System.arraycopy(valueArray, 0, newValueArray, 0, vl);
                System.arraycopy(existingParams, 0, newValueArray, vl, el);
                this.paramsMap.put(name, newValueArray);
            }
        }

        public String[] getParameterValues(String name) {
            String[] value = (String[])this.paramsMap.get(name);
            return value != null ? (String[])value.clone() : null;
        }

        public String getParameter(String name) {
            String[] values = (String[])this.paramsMap.get(name);
            return values != null && values.length > 0 ? values[0] : null;
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(this.paramsMap.keySet());
        }

        public Map getParameterMap() {
            HashMap clone = (HashMap)this.paramsMap.clone();
            for (Map.Entry entry : clone.entrySet()) {
                entry.setValue(((String[])entry.getValue()).clone());
            }
            return Collections.unmodifiableMap(clone);
        }
    }

    public static class MediaNodeAndEntryPath {
        private final Content mediaNode;
        private final String playlistEntryPath;

        public MediaNodeAndEntryPath(Content mediaNode, String playlistEntryPath) {
            this.mediaNode = mediaNode;
            this.playlistEntryPath = playlistEntryPath;
        }

        public Content getMediaNode() {
            return this.mediaNode;
        }

        public String getPlaylistEntryPath() {
            return this.playlistEntryPath;
        }
    }
}

