/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.playlist.tree;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.exchange.ExchangeException;
import info.magnolia.module.admininterface.AdminTreeMVCHandler;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.openutils.mgnlmedia.media.tags.el.MediaEl;
import net.sourceforge.openutils.mgnlmedia.playlist.tree.PlaylistsTree;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaylistsTreeMVCHandler
extends AdminTreeMVCHandler {
    private static Logger log = LoggerFactory.getLogger(PlaylistsTreeMVCHandler.class);

    public PlaylistsTreeMVCHandler(String name, HttpServletRequest request, HttpServletResponse response) {
        super(name, request, response);
    }

    protected void renderHeaderIncludes(StringBuffer html) {
        super.renderHeaderIncludes(html);
        html.append("<script type=\"text/javascript\">\n");
        html.append("mgnlTree.prototype.openPlaylist = function(path){ parent.openPlaylist(path); };\n");
        html.append("_mgnlTreeSaveNodeDataCallback = mgnlTreeSaveNodeDataCallback;\n");
        html.append("mgnlTreeSaveNodeDataCallback = function(params, html) {\n");
        html.append("  var path = null;\n");
        html.append("  if (params.isLabel) {\n");
        html.append("    path = params.id.replace(/[^\\/]*$/, html);\n");
        html.append("    var img = document.getElementById(params.treeName + '_' + params.id + '_Icon');\n");
        html.append("    if (img.src.indexOf('ico16-playlist.png') == -1) path = null;\n");
        html.append("  }\n");
        html.append("  _mgnlTreeSaveNodeDataCallback.apply(this, arguments);\n");
        html.append("  if (path) parent.openPlaylist(path);\n");
        html.append("};\n");
        html.append("</script>\n");
    }

    public String getTreeClass() {
        return PlaylistsTree.class.getName();
    }

    public String pasteNode(String pathOrigin, String pathSelected, int pasteType, int action) throws ExchangeException, RepositoryException {
        String movedHandle = super.pasteNode(pathOrigin, pathSelected, pasteType, action);
        if (!StringUtils.isEmpty((String)movedHandle)) {
            try {
                Content moved = this.getHierarchyManager().getContent(movedHandle);
                moved.getParent().updateMetaData();
                if (MediaEl.module().isSingleinstance()) {
                    try {
                        moved.getParent().getMetaData().setActivated();
                    }
                    catch (RepositoryException e) {
                        log.error("Error adding activated status to playlist entry node", (Throwable)e);
                    }
                }
                moved.getParent().save();
            }
            catch (RepositoryException re) {
                log.error("Problem when updating playlist activation status for " + movedHandle + " " + ClassUtils.getShortClassName(((Object)((Object)re)).getClass()) + ": " + re.getMessage(), (Throwable)re);
            }
        }
        return movedHandle;
    }

    public void deleteNode(String parentPath, String label) throws ExchangeException, RepositoryException {
        super.deleteNode(parentPath, label);
        Content parentNode = this.getHierarchyManager().getContent(parentPath);
        parentNode.updateMetaData();
        if (MediaEl.module().isSingleinstance()) {
            try {
                parentNode.getMetaData().setActivated();
            }
            catch (RepositoryException e) {
                log.error("Error adding activated status to playlist entry node", (Throwable)e);
            }
        }
        parentNode.save();
    }
}

