/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.playlist.pages;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.i18n.I18nContentSupportFactory;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.context.MgnlContext;
import info.magnolia.module.ModuleRegistry;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaTypeConfiguration;
import net.sourceforge.openutils.mgnlmedia.media.lifecycle.MediaModule;
import net.sourceforge.openutils.mgnlmedia.media.pages.MediaBean;
import net.sourceforge.openutils.mgnlmedia.media.pages.MediaBeanBuilder;
import net.sourceforge.openutils.mgnlmedia.media.pages.MessagesTemplatedMVCHandler;
import net.sourceforge.openutils.mgnlmedia.media.tags.el.MediaEl;
import net.sourceforge.openutils.mgnlmedia.playlist.pages.PlaylistBean;
import net.sourceforge.openutils.mgnlmedia.playlist.pages.PlaylistEntryBean;
import net.sourceforge.openutils.mgnlmedia.playlist.pages.PlaylistTrackExtensionContributor;
import net.sourceforge.openutils.mgnlmedia.playlist.utils.PlaylistIterateUtils;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaylistView
extends MessagesTemplatedMVCHandler {
    private Logger log = LoggerFactory.getLogger(PlaylistView.class);
    private String path;
    private PlaylistBean playlist;
    private String title;
    private String description;
    private String mediaHandle;
    private boolean success;
    private static final String VIEW_XSPF = "-xspf";
    private static final String VIEW_EXTJS = "-extjs";
    private String locale;
    private boolean xml;
    private List<Content> mediaContentList;
    private List<MediaBean> mediaBeans;

    public PlaylistView(String name, HttpServletRequest request, HttpServletResponse response) {
        super(name, request, response);
    }

    public void setPath(String path) {
        this.path = path;
    }

    public PlaylistBean getPlaylist() {
        return this.playlist;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMediaHandle() {
        return this.mediaHandle;
    }

    public void setMediaHandle(String mediaHandle) {
        this.mediaHandle = mediaHandle;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String show() {
        if (StringUtils.isNotBlank((String)this.path)) {
            Content node = ContentUtil.getContent((String)"playlists", (String)this.path);
            if (node != null) {
                HashMap<String, String> propNames = new HashMap<String, String>();
                propNames.put("title", "title");
                propNames.put("description", "description");
                propNames.put("tags", "tags");
                if (!StringUtils.isEmpty((String)this.locale)) {
                    Locale l = LocaleUtils.toLocale((String)this.locale);
                    if (!I18nContentSupportFactory.getI18nSupport().getFallbackLocale().equals(l)) {
                        for (Map.Entry entry : propNames.entrySet()) {
                            entry.setValue((String)entry.getValue() + "_" + l);
                        }
                    }
                }
                this.playlist = new PlaylistBean();
                this.playlist.setUuid(node.getUUID());
                this.playlist.setHandle(node.getHandle());
                this.playlist.setTitle(NodeDataUtil.getString((Content)node, (String)((String)propNames.get("title"))));
                this.playlist.setDescription(NodeDataUtil.getString((Content)node, (String)((String)propNames.get("description"))));
                ArrayList<PlaylistEntryBean> entries = new ArrayList<PlaylistEntryBean>();
                Iterator<PlaylistIterateUtils.MediaNodeAndEntryPath> iterator = PlaylistIterateUtils.iterate(node);
                while (iterator.hasNext()) {
                    PlaylistIterateUtils.MediaNodeAndEntryPath mediaNodeAndEntryPath = iterator.next();
                    Content media = mediaNodeAndEntryPath.getMediaNode();
                    if (media == null) continue;
                    PlaylistEntryBean entry = new PlaylistEntryBean();
                    entry.setHandle(mediaNodeAndEntryPath.getPlaylistEntryPath());
                    entry.setMedia(media.getUUID());
                    entry.setMediaHandle(media.getHandle());
                    MediaTypeConfiguration typeConf = MediaConfigurationManager.getInstance().getMediaTypeConfigurationFromMedia(media);
                    if (typeConf != null) {
                        entry.setMediaDialog(typeConf.getDialog());
                    }
                    entry.setThumbnail(MediaEl.thumbnail(media));
                    entry.setType(NodeDataUtil.getString((Content)media, (String)"type"));
                    entry.setTitle(I18nContentSupportFactory.getI18nSupport().getNodeData(media, (String)propNames.get("title")).getString());
                    entry.setDescription(I18nContentSupportFactory.getI18nSupport().getNodeData(media, (String)propNames.get("description")).getString());
                    entry.setTags(I18nContentSupportFactory.getI18nSupport().getNodeData(media, (String)propNames.get("tags")).getString());
                    entries.add(entry);
                }
                this.playlist.setEntries(entries);
                try {
                    this.playlist.setSearchBased(node.hasContent("search"));
                }
                catch (RepositoryException e) {}
            } else {
                this.log.warn("Node {} does not exist in playlist repository", (Object)this.path);
            }
        }
        return "show";
    }

    public String save() {
        this.success = false;
        Content node = ContentUtil.getContent((String)"playlists", (String)this.path);
        if (node != null) {
            try {
                NodeDataUtil.getOrCreateAndSet((Content)node, (String)"title", (Object)this.title);
                NodeDataUtil.getOrCreateAndSet((Content)node, (String)"description", (Object)this.description);
                if (MediaEl.module().isSingleinstance()) {
                    node.getMetaData().setActivated();
                }
                node.save();
                this.success = true;
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return VIEW_EXTJS;
    }

    public String saveMedia() {
        this.success = false;
        Content node = ContentUtil.getContent((String)"media", (String)this.mediaHandle);
        if (node != null) {
            try {
                NodeDataUtil.getOrCreateAndSet((Content)node, (String)"title", (Object)this.title);
                NodeDataUtil.getOrCreateAndSet((Content)node, (String)"description", (Object)this.description);
                if (MediaEl.module().isSingleinstance()) {
                    node.getMetaData().setActivated();
                }
                node.save();
                this.success = true;
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return VIEW_EXTJS;
    }

    public String xspf() throws IOException {
        String viewName = this.show();
        if (this.getPlaylist() == null) {
            this.response.sendError(404);
            return viewName;
        }
        this.mediaContentList = new ArrayList<Content>();
        for (PlaylistEntryBean plb : this.getPlaylist().getEntries()) {
            try {
                this.mediaContentList.add(MgnlContext.getHierarchyManager((String)"media").getContentByUUID(plb.getMedia()));
            }
            catch (RepositoryException e) {
                this.log.error("Error retrieving media {}", (Throwable)e);
            }
        }
        if (StringUtils.isEmpty((String)this.locale)) {
            this.locale = Locale.getDefault().toString();
        }
        if (this.xml) {
            this.response.setContentType("text/xml");
        } else {
            this.response.setContentType("application/xspf+xml");
        }
        return VIEW_XSPF;
    }

    public String mediaFolder() {
        Content folder = ContentUtil.getContent((String)"media", (String)this.path);
        if (folder != null) {
            Collection nodes = folder.getChildren(MediaConfigurationManager.MEDIA);
            this.mediaBeans = new ArrayList<MediaBean>(nodes.size());
            for (Content node : nodes) {
                MediaBean bean = new MediaBeanBuilder().apply(node);
                this.mediaBeans.add(bean);
            }
        }
        return "-mediaFolder";
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public List<Content> getMediaContentList() {
        return this.mediaContentList;
    }

    public void setMediaContentList(List<Content> mediaContentList) {
        this.mediaContentList = mediaContentList;
    }

    public List<MediaBean> getMediaBeans() {
        return this.mediaBeans;
    }

    public void setXml(boolean xml) {
        this.xml = xml;
    }

    public String playlistTitle() {
        return this.playlist.getTitle();
    }

    public String playlistLocation() {
        return "/playlists" + this.playlist.getHandle() + ".xspf?locale=" + this.locale;
    }

    public Map<String, Object> playlistMetas() {
        LinkedHashMap<String, Object> metas = new LinkedHashMap<String, Object>();
        metas.put("media:locale", this.locale);
        metas.put("media:playlist-id", this.playlist.getUuid());
        return metas;
    }

    public void writePlaylistTrackExtension(Content media, PrintWriter writer) {
        MediaModule module = (MediaModule)ModuleRegistry.Factory.getInstance().getModuleInstance("media");
        for (Object item : module.getPlaylistTrackExtensionContributors()) {
            PlaylistTrackExtensionContributor contributor = (PlaylistTrackExtensionContributor)item;
            contributor.addMediaAttributes(media, writer);
        }
    }
}

