/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.zip;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sourceforge.openutils.mgnlmedia.media.utils.MediaLoadUtils;
import net.sourceforge.openutils.mgnlmedia.media.zip.ZipImporter;
import net.sourceforge.openutils.mgnlmedia.media.zip.ZipImporterException;
import org.apache.commons.lang.StringUtils;

public class DefaultZipImporter
implements ZipImporter {
    public void importFromZip(ZipFile zip, String parentPath) throws ZipImporterException {
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                String filename;
                ZipEntry entry = entries.nextElement();
                String path = entry.getName();
                if (entry.isDirectory()) continue;
                InputStream inputStream = zip.getInputStream(entry);
                String parent = StringUtils.trimToEmpty((String)parentPath) + "/" + path;
                parent = StringUtils.replace((String)parent, (String)"\\", (String)"/");
                if (!(parent = StringUtils.replace((String)parent, (String)"//", (String)"/")).startsWith("/")) {
                    parent = "/" + parent;
                }
                if (StringUtils.startsWith((String)(filename = StringUtils.substringAfterLast((String)parent, (String)"/")), (String)".") || StringUtils.equalsIgnoreCase((String)filename, (String)"Thumbs.db")) continue;
                parent = StringUtils.substringBeforeLast((String)parent, (String)"/");
                MediaLoadUtils.loadEntry(inputStream, StringUtils.defaultIfEmpty((String)parent, (String)"/fromzip"), filename, false);
            }
        }
        catch (Exception e) {
            throw new ZipImporterException(e.getMessage(), e);
        }
    }
}

