/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.utils;

import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoFileConvenienceHelper;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import org.apache.commons.io.IOUtils;

public final class VideoMedataUtils {
    public static VideoMetaData parsefromStream(String extension, InputStream stream) throws IOException {
        if ("flv".equals(extension)) {
            return VideoMedataUtils.parseFLVfromStream(stream);
        }
        if ("mp4".equals(extension) || "m4v".equals(extension)) {
            return VideoMedataUtils.parseMP4fromStream(stream);
        }
        return null;
    }

    public static VideoMetaData parseFLVfromStream(InputStream stream) throws IOException {
        return VideoMedataUtils.getMetaData(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VideoMetaData parseMP4fromStream(InputStream stream) throws IOException {
        VideoMetaData meta = new VideoMetaData();
        File tempFile = File.createTempFile("medatadaextraction", ".mp4");
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));
        IOUtils.copy((InputStream)stream, (OutputStream)out);
        ((OutputStream)out).close();
        try {
            IsoBufferWrapper buf = new IsoBufferWrapper(tempFile);
            IsoFile isoFile = new IsoFile(buf);
            isoFile.parse();
            MovieBox box = (MovieBox)IsoFileConvenienceHelper.get((ContainerBox)isoFile, (String)"moov");
            meta.setDuration(box.getMovieHeaderBox().getDuration() / box.getMovieHeaderBox().getTimescale());
            meta.setFrameRate(box.getMovieHeaderBox().getRate());
            for (long trackid : box.getTrackNumbers()) {
                TrackHeaderBox thb = ((TrackBox)box.getTrackMetaData(trackid).getTrackBox()).getTrackHeaderBox();
                if (!(thb.getWidth() > 0.0)) continue;
                meta.setWidth((long)thb.getWidth());
                meta.setHeight((long)thb.getHeight());
                break;
            }
        }
        finally {
            tempFile.delete();
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VideoMetaData parseFLVfromUrl(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(5000);
        InputStream fis = connection.getInputStream();
        try {
            VideoMetaData videoMetaData = VideoMedataUtils.parseFLVfromStream(fis);
            return videoMetaData;
        }
        finally {
            IOUtils.closeQuietly((InputStream)fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VideoMetaData getMetaData(InputStream fis) throws IOException {
        VideoMetaData meta = new VideoMetaData();
        try {
            byte[] bytes = new byte[400];
            fis.read(bytes);
            meta = VideoMedataUtils.getMetaData(bytes);
        }
        finally {
            IOUtils.closeQuietly((InputStream)fis);
        }
        return meta;
    }

    protected static VideoMetaData getMetaData(byte[] bytes) {
        VideoMetaData meta = new VideoMetaData();
        meta.setDuration(VideoMedataUtils.getLong(bytes, "duration"));
        meta.setWidth(VideoMedataUtils.getLong(bytes, "width"));
        meta.setHeight(VideoMedataUtils.getLong(bytes, "height"));
        meta.setAudioDataRate(VideoMedataUtils.getDouble(bytes, "audiodatarate"));
        meta.setVideoDataRate(VideoMedataUtils.getDouble(bytes, "videodatarate"));
        meta.setFileSize(VideoMedataUtils.getLong(bytes, "filesize"));
        meta.setCreatedDate(VideoMedataUtils.getString(bytes, "creationdate"));
        meta.setMimeType(VideoMedataUtils.getString(bytes, "mimetype"));
        meta.setFrameRate(VideoMedataUtils.getDouble(bytes, "framerate"));
        return meta;
    }

    private static double getDouble(byte[] bytes, String property) {
        int offset = VideoMedataUtils.indexOf(bytes, property.getBytes());
        if (offset != -1) {
            return ByteBuffer.wrap(VideoMedataUtils.getBytes(bytes, offset + property.length() + 1, 8)).getDouble();
        }
        return -1.0;
    }

    private static long getLong(byte[] bytes, String property) {
        int offset = VideoMedataUtils.indexOf(bytes, property.getBytes());
        if (offset != -1) {
            return (long)ByteBuffer.wrap(VideoMedataUtils.getBytes(bytes, offset + property.length() + 1, 8)).getDouble();
        }
        return -1L;
    }

    private static String getString(byte[] bytes, String property) {
        int offset = VideoMedataUtils.indexOf(bytes, property.getBytes());
        if (offset != -1) {
            return new String(VideoMedataUtils.getBytes(bytes, offset + property.length() + 3, 24));
        }
        return null;
    }

    private static byte[] getBytes(byte[] bytes, int offset, int length) {
        byte[] requiredBytes = new byte[length];
        int i = offset;
        for (int j = 0; j < length; ++j) {
            requiredBytes[j] = bytes[i];
            ++i;
        }
        return requiredBytes;
    }

    static int indexOf(byte[] source, byte[] target) {
        byte first = target[0];
        int max = source.length - target.length;
        for (int i = 0; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + target.length - 1;
            int k = 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static class VideoMetaData {
        private long duration;
        private long width;
        private long height;
        private double audioDataRate;
        private double videoDataRate;
        private long fileSize;
        private String createdDate;
        private String mimeType;
        private double frameRate;

        public void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        public String getCreatedDate() {
            return this.createdDate;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setWidth(long width) {
            this.width = width;
        }

        public double getWidth() {
            return this.width;
        }

        public void setHeight(long height) {
            this.height = height;
        }

        public long getHeight() {
            return this.height;
        }

        public void setAudioDataRate(double audioDataRate) {
            this.audioDataRate = audioDataRate;
        }

        public double getAudioDataRate() {
            return this.audioDataRate;
        }

        public void setVideoDataRate(double videoDataRate) {
            this.videoDataRate = videoDataRate;
        }

        public double getVideoDataRate() {
            return this.videoDataRate;
        }

        public void setFileSize(long fileSize) {
            this.fileSize = fileSize;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public void setFrameRate(double frameRate) {
            this.frameRate = frameRate;
        }

        public double getFrameRate() {
            return this.frameRate;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }

        public long getDuration() {
            return this.duration;
        }
    }
}

