/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.utils;

import com.flazr.io.flv.FlvAtom;
import com.flazr.rtmp.RtmpHeader;
import com.flazr.rtmp.RtmpMessage;
import com.flazr.rtmp.RtmpWriter;
import com.flazr.rtmp.client.ClientOptions;
import com.flazr.rtmp.client.ClientPipelineFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.sourceforge.openutils.mgnlmedia.media.utils.VideoMedataUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RtmpMedatadaFetcher {
    private RtmpMedatadaFetcher() {
    }

    public static VideoMedataUtils.VideoMetaData fetchMetadata(String url, long timeoutInMs) throws IOException {
        String validUrl = StringUtils.substringBeforeLast((String)url, (String)".flv");
        ClientOptions options = new ClientOptions(validUrl, null);
        options.setLoad(1);
        options.getSwfHash();
        options.setLength(1);
        options.setClientVersionToUse(new byte[]{0, 0, 0, 0});
        MetadataWriter writer = new MetadataWriter();
        options.setWriterToSave((RtmpWriter)writer);
        ClientBootstrap bootstrap = RtmpMedatadaFetcher.getBootstrap(Executors.newCachedThreadPool(), options);
        ChannelFuture future = bootstrap.connect((SocketAddress)new InetSocketAddress(options.getHost(), options.getPort()));
        int j = 0;
        while ((long)j < timeoutInMs / 10L && writer.getByteArray().size() < 400) {
            future.getChannel().getCloseFuture().awaitUninterruptibly(10L);
            ++j;
        }
        bootstrap.getFactory().releaseExternalResources();
        return VideoMedataUtils.getMetaData(writer.getByteArray().toByteArray());
    }

    private static ClientBootstrap getBootstrap(Executor executor, ClientOptions options) {
        NioClientSocketChannelFactory factory = new NioClientSocketChannelFactory(executor, executor);
        ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)factory);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new ClientPipelineFactory(options));
        bootstrap.setOption("tcpNoDelay", (Object)true);
        bootstrap.setOption("keepAlive", (Object)true);
        return bootstrap;
    }

    static class MetadataWriter
    implements RtmpWriter {
        private Logger log = LoggerFactory.getLogger(MetadataWriter.class);
        private final ByteArrayOutputStream bos;
        private final int[] channelTimes = new int[65600];
        private int primaryChannel = -1;
        private final int seekTime;

        public MetadataWriter() {
            this.bos = new ByteArrayOutputStream();
            this.seekTime = 0;
            try {
                this.bos.write(FlvAtom.flvHeader().toByteBuffer().array());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
        }

        public void write(RtmpMessage message) {
            RtmpHeader header = message.getHeader();
            if (header.isAggregate()) {
                ChannelBuffer in = message.encode();
                while (in.readable()) {
                    int absoluteTime;
                    FlvAtom flvAtom = new FlvAtom(in);
                    this.channelTimes[this.primaryChannel] = absoluteTime = flvAtom.getHeader().getTime();
                    this.write(flvAtom);
                }
            } else {
                int channelId = header.getChannelId();
                this.channelTimes[channelId] = this.seekTime + header.getTime();
                if (this.primaryChannel == -1 && (header.isAudio() || header.isVideo())) {
                    this.log.info("first media packet for channel: {}", (Object)header);
                    this.primaryChannel = channelId;
                }
                if (header.getSize() <= 2) {
                    return;
                }
                this.write(new FlvAtom(header.getMessageType(), this.channelTimes[channelId], message.encode()));
            }
        }

        private void write(FlvAtom flvAtom) {
            try {
                this.bos.write(flvAtom.write().toByteBuffer().array());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public ByteArrayOutputStream getByteArray() {
            return this.bos;
        }
    }
}

