/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.utils;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.core.Path;
import info.magnolia.cms.security.AccessDeniedException;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.context.MgnlContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaTypeConfiguration;
import net.sourceforge.openutils.mgnlmedia.media.tags.el.MediaEl;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaLoadUtils {
    private static Logger log = LoggerFactory.getLogger(MediaLoadUtils.class);

    public static Content loadExternalVideo(String videourl, String parent, String filename, boolean overwrite) throws RepositoryException, IOException {
        log.debug("loading external video {}/{} with url {}", new Object[]{parent, filename, videourl});
        MediaTypeConfiguration mtc = MediaConfigurationManager.getInstance().getTypes().get("youtube");
        String cleanFilename = Path.getValidatedLabel((String)videourl);
        Content media = MediaLoadUtils.createMediaNode(mtc, parent, cleanFilename, overwrite);
        media.setNodeData("videoUrl", videourl);
        mtc.getHandler().onPostSave(media);
        return media;
    }

    public static Content loadEntry(InputStream inputStream, String parent, String filename, boolean overwrite) throws RepositoryException, IOException {
        log.debug("loading image {} {}", (Object)parent, (Object)filename);
        String extension = StringUtils.substringAfterLast((String)filename, (String)".");
        String cleanFilename = StringUtils.substringBeforeLast((String)filename, (String)".");
        MediaTypeConfiguration mtc = MediaConfigurationManager.getMediaHandlerFromExtension(extension);
        if (mtc != null) {
            Content media = MediaLoadUtils.createMediaNode(mtc, parent, cleanFilename, overwrite);
            File f = File.createTempFile("entry", "." + extension);
            FileOutputStream fTemp = new FileOutputStream(f);
            IOUtils.copy((InputStream)inputStream, (OutputStream)fTemp);
            IOUtils.closeQuietly((OutputStream)fTemp);
            mtc.getHandler().saveFromZipFile(media, f, cleanFilename, extension);
            MgnlContext.getSystemContext().getHierarchyManager("media").save();
            FileUtils.deleteQuietly((File)f);
            return media;
        }
        return null;
    }

    private static Content createMediaNode(MediaTypeConfiguration mtc, String parent, String filename, boolean overwrite) throws RepositoryException, AccessDeniedException {
        Content existing;
        HierarchyManager mgr = MgnlContext.getSystemContext().getHierarchyManager("media");
        Content parentNode = MediaLoadUtils.getOrCreateFullPath(mgr, parent);
        String mediaName = Path.getValidatedLabel((String)filename);
        if (overwrite && (existing = parentNode.getChildByName(mediaName)) != null) {
            existing.delete();
            mgr.save();
        }
        Content media = mgr.createContent(parent, Path.getUniqueLabel((Content)parentNode, (String)mediaName), MediaConfigurationManager.MEDIA.getSystemName());
        MediaLoadUtils.setNodedataOnlyIfNotExisting(media, "creator", MgnlContext.getUser().getName());
        MediaLoadUtils.setNodedataOnlyIfNotExisting(media, "creationDate", Calendar.getInstance());
        NodeDataUtil.getOrCreateAndSet((Content)media, (String)"type", (Object)mtc.getName());
        NodeDataUtil.getOrCreateAndSet((Content)media, (String)"modificationDate", (Object)Calendar.getInstance());
        NodeDataUtil.getOrCreateAndSet((Content)media, (String)"modificationUser", (Object)MgnlContext.getUser().getName());
        if (MediaEl.module().isSingleinstance()) {
            media.getMetaData().setActivated();
        }
        mgr.save();
        return media;
    }

    private static void setNodedataOnlyIfNotExisting(Content media, String key, Object value) throws RepositoryException, AccessDeniedException {
        if (media.hasNodeData(key)) {
            NodeDataUtil.getOrCreateAndSet((Content)media, (String)key, (Object)value);
        }
    }

    public static Content getOrCreateFullPath(HierarchyManager mgr, String path) throws RepositoryException {
        String[] contentNodeNames = path.split("/");
        Content currContent = mgr.getRoot();
        for (String contentNodeName : contentNodeNames) {
            if (!StringUtils.isNotEmpty((String)contentNodeName)) continue;
            currContent = ContentUtil.getOrCreateContent((Content)currContent, (String)contentNodeName, (ItemType)MediaConfigurationManager.FOLDER);
            if (!MediaEl.module().isSingleinstance() || currContent.getMetaData().getIsActivated()) continue;
            currContent.getMetaData().setActivated();
        }
        return currContent;
    }
}

