/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.utils;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import info.magnolia.cms.core.NodeData;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.sourceforge.openutils.mgnlmedia.media.utils.BadImageFormatException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpegUtils {
    private static Logger log = LoggerFactory.getLogger(JpegUtils.class);

    public static BufferedImage createJPEG4(Raster raster, boolean ycckProfile) {
        int w = raster.getWidth();
        int h = raster.getHeight();
        byte[] rgb = new byte[w * h * 3];
        if (ycckProfile) {
            float[] Y = raster.getSamples(0, 0, w, h, 0, (float[])null);
            float[] Cb = raster.getSamples(0, 0, w, h, 1, (float[])null);
            float[] Cr = raster.getSamples(0, 0, w, h, 2, (float[])null);
            float[] K = raster.getSamples(0, 0, w, h, 3, (float[])null);
            int i = 0;
            int imax = Y.length;
            int base = 0;
            while (i < imax) {
                float k = 220.0f - K[i];
                float y = 255.0f - Y[i];
                float cb = 255.0f - Cb[i];
                float cr = 255.0f - Cr[i];
                double val = (double)y + 1.402 * (double)(cr - 128.0f) - (double)k;
                rgb[base] = (byte)((val = (val - 128.0) * (double)0.65f + 128.0) < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
                val = (double)y - 0.34414 * (double)(cb - 128.0f) - 0.71414 * (double)(cr - 128.0f) - (double)k;
                val = (val - 128.0) * (double)0.65f + 128.0;
                rgb[base + 1] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
                val = (double)y + 1.772 * (double)(cb - 128.0f) - (double)k;
                val = (val - 128.0) * (double)0.65f + 128.0;
                rgb[base + 2] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
                ++i;
                base += 3;
            }
        } else {
            int[] C = raster.getSamples(0, 0, w, h, 0, (int[])null);
            int[] M = raster.getSamples(0, 0, w, h, 1, (int[])null);
            int[] Y = raster.getSamples(0, 0, w, h, 2, (int[])null);
            int[] K = raster.getSamples(0, 0, w, h, 3, (int[])null);
            int i = 0;
            int imax = C.length;
            int base = 0;
            while (i < imax) {
                int c = 255 - C[i];
                int m = 255 - M[i];
                int y = 255 - Y[i];
                int k = 255 - K[i];
                float kk = (float)k / 255.0f;
                rgb[base] = (byte)(255.0f - Math.min(255.0f, (float)c * kk + (float)k));
                rgb[base + 1] = (byte)(255.0f - Math.min(255.0f, (float)m * kk + (float)k));
                rgb[base + 2] = (byte)(255.0f - Math.min(255.0f, (float)y * kk + (float)k));
                ++i;
                base += 3;
            }
        }
        raster = Raster.createInterleavedRaster(new DataBufferByte(rgb, rgb.length), w, h, w * 3, 3, new int[]{0, 1, 2}, null);
        ColorSpace cs = ColorSpace.getInstance(1000);
        ComponentColorModel cm = new ComponentColorModel(cs, false, true, 1, 0);
        return new BufferedImage(cm, (WritableRaster)raster, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BufferedImage processNonStandardImage(NodeData image) {
        JpegUtils.log.debug("Processing {}", (Object)image.getHandle());
        is2 = image.getStream();
        try {
            block24: {
                input = ImageIO.createImageInputStream(is2);
                readers = ImageIO.getImageReaders(input);
                if (readers == null || !readers.hasNext()) {
                    throw new RuntimeException("No ImageReaders found");
                }
                reader = readers.next();
                reader.setInput(input);
                format = reader.getFormatName();
                if (!"JPEG".equalsIgnoreCase(format) && !"JPG".equalsIgnoreCase(format)) throw new BadImageFormatException("No ImageReaders found for " + image.getHandle());
                raster = reader.readRaster(0, reader.getDefaultReadParam());
                ycckProfile = false;
                is3 = image.getStream();
                try {
                    segmentReader = new JpegSegmentReader(is3);
                    exifSegment /* !! */  = segmentReader.readSegment((byte)-18);
                    if (exifSegment /* !! */  == null) break block24;
                    switch (exifSegment /* !! */ [11]) {
                        case 2: {
                            ycckProfile = true;
                            ** break;
lbl23:
                            // 1 sources

                            break;
                        }
                        case 1: {
                            ** break;
lbl26:
                            // 1 sources

                            break;
                        }
                        ** default:
lbl28:
                        // 1 sources

                        break;
                    }
                }
                catch (JpegProcessingException e1) {
                    JpegUtils.log.warn("Unable to read color space");
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is3);
                }
            }
            if (input != null) {
                input.close();
            }
            reader.dispose();
            if (ycckProfile) {
                e1 = JpegUtils.createJPEG4(raster, ycckProfile);
                return e1;
            }
            is4 = image.getStream();
            try {
                exifSegment /* !! */  = (byte[])JPEGCodec.createJPEGDecoder((InputStream)is4).decodeAsBufferedImage();
            }
            catch (ImageFormatException ife) {
                var11_15 = JpegUtils.createJPEG4(raster, ycckProfile);
                IOUtils.closeQuietly((InputStream)is4);
                IOUtils.closeQuietly((InputStream)is2);
                return var11_15;
                {
                    catch (Throwable var12_16) {
                        try {
                            IOUtils.closeQuietly((InputStream)is4);
                            throw var12_16;
                        }
                        catch (IOException e1) {
                            JpegUtils.log.error("Unable to handle " + image.getHandle() + ": " + e1.getMessage(), (Throwable)e1);
                            throw new BadImageFormatException(image.getHandle(), e1);
                        }
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)is4);
            return exifSegment /* !! */ ;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is2);
        }
    }
}

