/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.utils;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.NodeData;
import info.magnolia.context.Context;
import info.magnolia.context.MgnlContext;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.color.CMMException;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import net.sourceforge.openutils.mgnlmedia.media.configuration.ImageProcessorsManager;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaTypeConfiguration;
import net.sourceforge.openutils.mgnlmedia.media.processors.ImagePostProcessor;
import net.sourceforge.openutils.mgnlmedia.media.utils.BadImageFormatException;
import net.sourceforge.openutils.mgnlmedia.media.utils.IcoUtils;
import net.sourceforge.openutils.mgnlmedia.media.utils.JpegUtils;
import net.sourceforge.openutils.mgnlmedia.media.utils.ZeroSizeImageException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageUtils {
    private static final String RESOLUTION_PREVIEW_SIZE = "l450x350";
    private static final String RESOLUTION_THUMBNAIL_SIZE = "l100x100";
    private static final String RESOLUTION_PREVIEW = "preview";
    private static final String RESOLUTION_THUMBNAIL = "thumbnail";
    private static Logger log = LoggerFactory.getLogger(ImageUtils.class);
    private static SimpleDateFormat sdf;
    public static String RESOLUTION_PROPERTY;
    private static final String[] extensions;

    private ImageUtils() {
    }

    private static int getType(ColorModel cm) {
        if (cm.getTransparency() == 2) {
            if (cm.isAlphaPremultiplied()) {
                return 7;
            }
            return 6;
        }
        if (cm.getTransparency() == 3) {
            if (cm.isAlphaPremultiplied()) {
                return 3;
            }
            return 2;
        }
        if (cm.getPixelSize() == 8) {
            return 5;
        }
        return 1;
    }

    public static BufferedImage resizeImage(BufferedImage original, int x, int y) {
        return ImageUtils.resizeImage(original, x, y, x, y, null);
    }

    public static BufferedImage resizeImage(BufferedImage original, int x, int y, int canvasX, int canvasY, Color background) {
        BufferedImage resizedImage;
        if (x <= 0) {
            x = 1;
        }
        if (y <= 0) {
            y = 1;
        }
        if (canvasX <= 0) {
            canvasX = 1;
        }
        if (canvasY <= 0) {
            canvasY = 1;
        }
        try {
            resizedImage = new BufferedImage(canvasX, canvasY, ImageUtils.getType(original.getColorModel()));
        }
        catch (NegativeArraySizeException e) {
            throw new RuntimeException("NegativeArraySizeException caught when resizing image to [" + canvasX + ", " + canvasY + "]");
        }
        Graphics2D graphics2D = resizedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (canvasX > x || canvasY > y) {
            graphics2D.clearRect(0, 0, canvasX, canvasY);
            if (background == null && original.getColorModel().getTransparency() == 1) {
                background = Color.WHITE;
            }
            if (background != null) {
                graphics2D.setColor(background);
                if (canvasX > x) {
                    graphics2D.fillRect(0, 0, (canvasX - x) / 2, canvasY);
                    graphics2D.fillRect(x + (canvasX - x) / 2, 0, canvasX, canvasY);
                }
                if (canvasY > y) {
                    graphics2D.fillRect(0, 0, canvasX, (canvasY - y) / 2);
                    graphics2D.fillRect(0, y + (canvasY - y) / 2, canvasX, canvasY);
                }
            }
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        AffineTransform at = new AffineTransform();
        double delta = (double)x / (double)original.getWidth();
        if (x > original.getWidth()) {
            at.scale(delta, delta);
            at.translate((double)(canvasX - x) / (2.0 * delta), (double)(canvasY - y) / (2.0 * delta));
        } else if (x < original.getWidth()) {
            original = ImageUtils.getScaledInstance(original, x, y, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
            at.translate((double)(canvasX - x) / 2.0, (double)(canvasY - y) / 2.0);
        }
        graphics2D.drawImage(original, at, null);
        graphics2D.dispose();
        return resizedImage;
    }

    public static BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int h;
        int w;
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        if (higherQuality) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }

    public static BufferedImage cropImage(BufferedImage original, int left, int top, int width, int height) {
        BufferedImage resizedImage = new BufferedImage(width, height, ImageUtils.getType(original.getColorModel()));
        Graphics2D graphics2D = resizedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        AffineTransform at = new AffineTransform();
        at.translate(-left, -top);
        graphics2D.drawImage(original, at, null);
        graphics2D.dispose();
        return resizedImage;
    }

    public static BufferedImage addRoundedCorners(BufferedImage original, Color backgroundColor, int radius) {
        BufferedImage roundedImage;
        int originalImageType = ImageUtils.getType(original.getColorModel());
        int roundedCornersImageType = 6;
        if (originalImageType != 6) {
            if (originalImageType != 7) {
                if (backgroundColor == null) {
                    backgroundColor = Color.WHITE;
                }
            } else {
                roundedCornersImageType = 7;
            }
        }
        try {
            roundedImage = new BufferedImage(original.getWidth(), original.getHeight(), roundedCornersImageType);
        }
        catch (NegativeArraySizeException e) {
            throw new RuntimeException("NegativeArraySizeException caught when adding rounded corners");
        }
        Graphics2D roundedGraphics2D = roundedImage.createGraphics();
        roundedGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        roundedGraphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        roundedGraphics2D.setColor(Color.WHITE);
        roundedGraphics2D.fillRoundRect(0, 0, original.getWidth(), original.getHeight(), radius, radius);
        roundedGraphics2D.setComposite(AlphaComposite.SrcIn);
        roundedGraphics2D.drawImage(original, 0, 0, original.getWidth(), original.getHeight(), null);
        if (backgroundColor != null) {
            BufferedImage destImage;
            try {
                destImage = new BufferedImage(original.getWidth(), original.getHeight(), originalImageType);
            }
            catch (NegativeArraySizeException e) {
                throw new RuntimeException("NegativeArraySizeException caught when resizing image]");
            }
            Graphics2D destImageGraphics2D = destImage.createGraphics();
            destImageGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            destImageGraphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            destImageGraphics2D.setBackground(backgroundColor);
            destImageGraphics2D.clearRect(0, 0, original.getWidth(), original.getHeight());
            destImageGraphics2D.drawImage(roundedImage, 0, 0, original.getWidth(), original.getHeight(), null);
            return destImage;
        }
        return roundedImage;
    }

    public static void saveResolution(BufferedImage image, Content saveTo, String extension, float quality, boolean forceProgressive) throws RepositoryException, IOException {
        ImageUtils.saveResolution(image, saveTo, null, extension, quality, forceProgressive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveResolution(BufferedImage image, Content saveTo, String name, String extension, float quality, boolean forceProgressive) throws RepositoryException, IOException {
        String resolution;
        Content resolutions = ImageUtils.getResolutionsNode(saveTo);
        if (resolutions == null) {
            resolutions = saveTo.createContent("resolutions", MediaConfigurationManager.RESOLUTIONS);
            resolutions.getMetaData().setModificationDate();
            saveTo.save();
        }
        if ((resolution = name) == null) {
            resolution = "res-" + image.getWidth() + "x" + image.getHeight();
        }
        String originalRes = resolution;
        resolution = ImageUtils.getResolutionPath(resolution);
        Lock lock = resolutions.lock(false, true, 5000L);
        try {
            NodeData nd;
            if (resolutions.hasNodeData(resolution)) {
                nd = resolutions.getNodeData(resolution);
                nd.delete();
                resolutions.save();
            }
            nd = resolutions.createNodeData(resolution, 2);
            final PipedInputStream stream = new PipedInputStream();
            PipedOutputStream outputstream = new PipedOutputStream(stream);
            log.debug("setting value to {}", (Object)nd.getHandle());
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        nd.setValue((InputStream)stream);
                    }
                    catch (RepositoryException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
            t.start();
            long count = ImageUtils.getStream(image, extension, quality, forceProgressive, outputstream);
            IOUtils.closeQuietly((OutputStream)outputstream);
            try {
                t.join();
            }
            catch (InterruptedException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
            IOUtils.closeQuietly((InputStream)stream);
            String mimetype = "image/" + extension;
            if ("jpg".equals(extension)) {
                mimetype = "image/jpeg";
            }
            nd.setAttribute(RESOLUTION_PROPERTY, originalRes);
            nd.setAttribute("extension", extension);
            nd.setAttribute("fileName", saveTo.getName());
            nd.setAttribute("jcr:mimeType", mimetype);
            nd.setAttribute("jcr:lastModified", GregorianCalendar.getInstance(TimeZone.getDefault()));
            nd.setAttribute("width", "" + image.getWidth());
            nd.setAttribute("height", "" + image.getHeight());
            nd.setAttribute("size", "" + count);
            resolutions.save();
        }
        finally {
            resolutions.unlock();
        }
    }

    public static String getResolutionPath(String resolution) {
        if (resolution.indexOf(59) > 0) {
            return StringUtils.substringBefore((String)resolution, (String)";") + "-p" + StringUtils.substringAfter((String)resolution, (String)";").hashCode();
        }
        return resolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getStream(BufferedImage image, String extension, float quality, boolean forceProgressive, OutputStream outputstream) throws IOException {
        CountBytesBufferedOutputStream out;
        block17: {
            out = new CountBytesBufferedOutputStream(outputstream);
            try {
                Iterator<ImageWriter> writers;
                if (extension.equals("jpg")) {
                    JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                    if (quality != 1.0f) {
                        JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(image);
                        param.setQuality(quality, true);
                        encoder.setJPEGEncodeParam(param);
                    }
                    encoder.encode(image);
                    break block17;
                }
                String outputextension = extension;
                if (StringUtils.equals((String)extension, (String)"ico") || StringUtils.equals((String)extension, (String)"gif")) {
                    outputextension = "png";
                }
                if ((writers = ImageIO.getImageWritersBySuffix(outputextension)) != null && writers.hasNext()) {
                    ImageWriter imageWriter = writers.next();
                    ImageWriteParam params = imageWriter.getDefaultWriteParam();
                    try {
                        String[] compressionTypes = params.getCompressionTypes();
                        if (compressionTypes != null && compressionTypes.length > 0) {
                            params.setCompressionMode(2);
                            params.setCompressionType(compressionTypes[0]);
                            params.setCompressionQuality(quality);
                        } else {
                            params.setCompressionMode(3);
                        }
                        if (forceProgressive) {
                            params.setProgressiveMode(1);
                        } else {
                            params.setProgressiveMode(0);
                        }
                    }
                    catch (UnsupportedOperationException e) {
                        // empty catch block
                    }
                    params.setDestinationType(new ImageTypeSpecifier(image.getColorModel(), image.getSampleModel()));
                    ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(out);
                    imageWriter.setOutput(imageOutputStream);
                    IIOImage iioimage = new IIOImage(image, null, null);
                    try {
                        imageWriter.write(null, iioimage, params);
                        break block17;
                    }
                    catch (NullPointerException e) {
                        image.createGraphics().drawRect(0, 0, 1, 1);
                        imageWriter.write(null, iioimage, params);
                        break block17;
                    }
                    finally {
                        imageOutputStream.close();
                        imageWriter.dispose();
                    }
                }
                ImageIO.write((RenderedImage)image, outputextension, out);
            }
            catch (IOException ex) {
                log.error("Error writing image to buffer", (Throwable)ex);
                throw ex;
            }
        }
        return out.count;
    }

    public static boolean checkOrCreateResolution(Content media, String resolutionTarget) {
        return ImageUtils.checkOrCreateResolution(media, resolutionTarget, "original");
    }

    public static boolean checkOrCreateResolution(final Content media, final String resolutionTarget, String nodeDataName) {
        Content resolutions = ImageUtils.getResolutionsNode(media);
        String resolution = resolutionTarget;
        if (!RESOLUTION_THUMBNAIL.equals(resolutionTarget) && !RESOLUTION_PREVIEW.equals(resolutionTarget)) {
            resolution = "res-" + resolutionTarget;
        }
        try {
            if (resolutions != null && resolutions.hasNodeData(ImageUtils.getResolutionPath(resolution))) {
                return true;
            }
        }
        catch (RepositoryException e1) {
            // empty catch block
        }
        String type = media.getNodeData("type").getString();
        if (StringUtils.equals((String)type, (String)"other")) {
            return false;
        }
        if (nodeDataName == null) {
            MediaTypeConfiguration mtc = MediaConfigurationManager.getInstance().getMediaTypeConfigurationFromMedia(media);
            nodeDataName = mtc == null ? "original" : mtc.getHandler().getPreviewImageNodeDataName();
        }
        try {
            if (!media.hasNodeData(nodeDataName)) {
                return false;
            }
        }
        catch (RepositoryException e2) {
            log.warn(e2.getMessage(), (Throwable)e2);
        }
        final String originalNodeDataName = nodeDataName;
        try {
            ImageUtils.doInSystemContext(new MgnlContext.SystemContextOperation(){

                public void exec() {
                    BufferedImage img;
                    Content node;
                    long timestart = System.currentTimeMillis();
                    HierarchyManager hm = MgnlContext.getHierarchyManager((String)"media");
                    String resolutionstring = resolutionTarget;
                    if (ImageUtils.RESOLUTION_THUMBNAIL.equals(resolutionstring)) {
                        resolutionstring = ImageUtils.RESOLUTION_THUMBNAIL_SIZE;
                    }
                    if (ImageUtils.RESOLUTION_PREVIEW.equals(resolutionstring)) {
                        resolutionstring = ImageUtils.RESOLUTION_PREVIEW_SIZE;
                    }
                    String resolutioNodeName = "res-" + resolutionstring;
                    if (ImageUtils.RESOLUTION_THUMBNAIL.equals(resolutionTarget) || ImageUtils.RESOLUTION_PREVIEW.equals(resolutionTarget)) {
                        resolutioNodeName = resolutionTarget;
                    }
                    try {
                        node = hm.getContent(media.getHandle());
                    }
                    catch (RepositoryException e) {
                        throw new RuntimeException(e);
                    }
                    NodeData image = node.getNodeData(originalNodeDataName);
                    if (image.getContentLength() == 0L) {
                        throw new ZeroSizeImageException(image.getHandle());
                    }
                    String outputextension = image.getAttribute("extension");
                    if (!Arrays.asList(extensions).contains(outputextension)) {
                        outputextension = "jpg";
                    }
                    BufferedImage original = ImageUtils.createBufferedImage(image);
                    Map params = ImageUtils.parseParameters(resolutionstring);
                    try {
                        img = ImageUtils.getImageForResolution(original, resolutionstring, params);
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException(e);
                    }
                    try {
                        float quality = 0.8f;
                        if (StringUtils.isNotEmpty((String)((String)params.get("quality")))) {
                            try {
                                quality = NumberUtils.toFloat((String)((String)params.get("quality")));
                                if (quality > 1.0f) {
                                    quality = 1.0f;
                                }
                            }
                            catch (NumberFormatException ex) {
                                log.error("quality parameter must be a float number but was {}", params.get("quality"));
                            }
                        }
                        boolean forceProgressive = false;
                        if (StringUtils.isNotEmpty((String)((String)params.get("progressive")))) {
                            forceProgressive = true;
                        }
                        ImageUtils.saveResolution(img, node, resolutioNodeName, outputextension, quality, forceProgressive);
                    }
                    catch (RepositoryException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    try {
                        hm.save();
                    }
                    catch (RepositoryException e) {
                        throw new RuntimeException(e);
                    }
                    log.info("Generated {} for {} in {} milliseconds", new Object[]{resolutioNodeName, node.getHandle(), System.currentTimeMillis() - timestart});
                }
            });
        }
        catch (BadImageFormatException e) {
            if (e.getCause() != null) {
                log.warn(e.getMessage(), e.getCause());
            } else {
                log.warn("Unable to extract a valid image from " + media.getHandle() + " (no message)");
            }
            try {
                media.setNodeData("bad_image_marker", media.getNodeData("bad_image_marker").getLong() + 1L);
                media.save();
            }
            catch (RepositoryException e1) {
                // empty catch block
            }
            return false;
        }
        catch (ZeroSizeImageException ex) {
            log.error(ex.getMessage());
            return false;
        }
        catch (RuntimeException ex) {
            log.error(ClassUtils.getShortClassName(ex.getClass()) + " checking resolution for " + media.getHandle() + ": " + ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    protected static Content getResolutionsNode(Content media) {
        Content resolutions = null;
        try {
            if (media.hasContent("resolutions")) {
                resolutions = media.getContent("resolutions");
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return resolutions;
    }

    private static Map<String, String> parseParameters(String resolution) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.contains((String)resolution, (String)";")) {
            String[] tokens;
            String parameters = StringUtils.substringAfter((String)resolution, (String)";");
            resolution = StringUtils.substringBefore((String)resolution, (String)";");
            for (String token : tokens = StringUtils.split((String)parameters, (char)',')) {
                if (token.indexOf("=") > 0) {
                    String[] keyvalue = StringUtils.split((String)token, (char)'=');
                    params.put(keyvalue[0], keyvalue[1]);
                    continue;
                }
                params.put(token, "true");
            }
        }
        return params;
    }

    public static BufferedImage getImageForResolution(BufferedImage original, String resolution, Map<String, String> params) {
        if (original == null) {
            throw new IllegalArgumentException("input image is null");
        }
        if (resolution == null || resolution.length() < 1) {
            throw new IllegalArgumentException("Invalid resolution: " + resolution);
        }
        BufferedImage img = null;
        resolution = StringUtils.lowerCase((String)resolution);
        char controlChar = resolution.charAt(0);
        Point size = ImageUtils.parseForSize(resolution);
        if (ImageProcessorsManager.getInstance().isValidControlChar(controlChar)) {
            img = ImageProcessorsManager.getInstance().getImageResolutionProcessor(controlChar).getImageForResolution(original, size.x, size.y, params);
        } else {
            if (controlChar < '0' || controlChar > '9') {
                throw new IllegalArgumentException("Invalid control char: " + controlChar);
            }
            img = ImageProcessorsManager.getInstance().getDefaultImageResolutionProcessor().getImageForResolution(original, size.x, size.y, params);
        }
        for (ImagePostProcessor ipp : ImageProcessorsManager.getInstance().getImagePostProcessorsList()) {
            img = ipp.processImage(img, size.x, size.y, params);
        }
        return img;
    }

    public static String getExtension(Content media, String resolution) {
        try {
            Content resolutions = media.getContent("resolutions");
            NodeData res = resolutions.getNodeData(resolution);
            return res.getAttribute("extension");
        }
        catch (RepositoryException ex) {
            return "jpg";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createBufferedImage(NodeData image) {
        InputStream is = image.getStream();
        String ext = image.getAttribute("extension");
        log.debug("processing {}, extension {}", (Object)image.getHandle(), (Object)ext);
        try {
            BufferedImage buffered;
            if ((StringUtils.equalsIgnoreCase((String)ext, (String)"ico") || StringUtils.equalsIgnoreCase((String)ext, (String)"bmp")) && (buffered = IcoUtils.createBufferedImage(image)) != null) {
                BufferedImage bufferedImage = buffered;
                return bufferedImage;
            }
            BufferedImage result = ImageIO.read(is);
            if (result == null) {
                throw new BadImageFormatException("Unable to handle " + image.getHandle() + " (no message)");
            }
            BufferedImage bufferedImage = result;
            return bufferedImage;
        }
        catch (IOException e) {
            BufferedImage result = JpegUtils.processNonStandardImage(image);
            if (result == null) {
                throw new BadImageFormatException("Unable to handle " + image.getHandle(), e);
            }
            BufferedImage bufferedImage = result;
            return bufferedImage;
        }
        catch (CMMException e) {
            BufferedImage result = JpegUtils.processNonStandardImage(image);
            if (result == null) {
                throw new BadImageFormatException("Unable to handle " + image.getHandle(), e);
            }
            BufferedImage bufferedImage = result;
            return bufferedImage;
        }
        catch (IllegalArgumentException e) {
            BufferedImage result = JpegUtils.processNonStandardImage(image);
            if (result == null) {
                throw new BadImageFormatException("Unable to handle " + image.getHandle(), e);
            }
            BufferedImage bufferedImage = result;
            return bufferedImage;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private static String normalizeResolutionString(String res) {
        String resolution = StringUtils.lowerCase((String)res);
        if (RESOLUTION_THUMBNAIL.equals(resolution)) {
            return RESOLUTION_THUMBNAIL_SIZE;
        }
        if (RESOLUTION_PREVIEW.equals(resolution)) {
            return RESOLUTION_PREVIEW_SIZE;
        }
        return resolution;
    }

    public static Point parseForSize(String res) {
        Point size = new Point();
        String resolution = ImageUtils.normalizeResolutionString(res);
        if (StringUtils.contains((String)resolution, (String)";")) {
            resolution = StringUtils.substringBefore((String)resolution, (String)";");
        }
        if (ImageProcessorsManager.getInstance().isValidControlChar(resolution.charAt(0)) || resolution.charAt(0) < '0' || resolution.charAt(0) > '9') {
            resolution = resolution.substring(1);
        }
        String[] resXY = StringUtils.split((String)resolution, (String)"x");
        size.x = NumberUtils.toInt((String)resXY[0]);
        size.y = NumberUtils.toInt((String)resXY[1]);
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doInSystemContext(MgnlContext.SystemContextOperation op) {
        Context originalCtx = MgnlContext.hasInstance() ? MgnlContext.getInstance() : null;
        try {
            MgnlContext.setInstance((Context)MgnlContext.getSystemContext());
            op.exec();
        }
        finally {
            MgnlContext.setInstance((Context)originalCtx);
        }
    }

    static {
        RESOLUTION_PROPERTY = "resolution";
        extensions = new String[]{"jpg", "jpeg", "gif", "png", "ico"};
        sdf = new SimpleDateFormat();
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    static class CountBytesBufferedOutputStream
    extends BufferedOutputStream {
        private int count = 0;

        public CountBytesBufferedOutputStream(OutputStream out, int size) {
            super(out, size);
        }

        public CountBytesBufferedOutputStream(OutputStream in) {
            super(in);
        }

        public int getCount() {
            return this.count;
        }

        public synchronized void write(byte[] b, int off, int len) throws IOException {
            this.count += len;
            super.write(b, off, len);
        }
    }
}

