/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.uri;

import info.magnolia.cms.beans.config.URI2RepositoryMapping;
import info.magnolia.context.MgnlContext;
import info.magnolia.link.Link;
import javax.jcr.RepositoryException;
import net.sourceforge.openutils.mgnlmedia.media.tags.el.MediaEl;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaURI2RepositoryMapping
extends URI2RepositoryMapping {
    private Logger log = LoggerFactory.getLogger(MediaURI2RepositoryMapping.class);

    public String getURI(Link uuidLink) {
        String uri;
        block3: {
            String urisimple = uuidLink.getHandle();
            try {
                uri = MediaEl.url(MgnlContext.getHierarchyManager((String)this.getRepository()).getContent(urisimple));
            }
            catch (RepositoryException e) {
                this.log.warn(((Object)((Object)e)).getClass().getName() + " resolving " + urisimple, (Throwable)e);
                uri = urisimple;
                if (StringUtils.isNotEmpty((String)this.getHandlePrefix())) {
                    uri = StringUtils.removeStart((String)uri, (String)this.getHandlePrefix());
                }
                if (!StringUtils.isNotEmpty((String)this.getURIPrefix())) break block3;
                uri = this.getURIPrefix() + "/" + uri;
            }
        }
        return this.cleanHandle(uri);
    }

    private String cleanHandle(String handle) {
        if (handle == null) {
            return null;
        }
        if (!handle.startsWith("/")) {
            handle = "/" + handle;
        }
        while (handle.indexOf("//") != -1) {
            handle = StringUtils.replace((String)handle, (String)"//", (String)"/");
        }
        return handle;
    }
}

