/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.types.impl;

import info.magnolia.cms.core.Content;
import javax.jcr.RepositoryException;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.types.impl.BaseTypeHandler;
import net.sourceforge.openutils.mgnlmedia.media.utils.ImageUtils;

public abstract class MediaWithPreviewImageTypeHandler
extends BaseTypeHandler {
    public static final String PREVIEW_NODEDATA_NAME = "image";

    public String getThumbnailUrl(Content media) {
        if (this.hasPreview(media)) {
            if (!ImageUtils.checkOrCreateResolution(media, "thumbnail", PREVIEW_NODEDATA_NAME)) {
                return "";
            }
            return MediaConfigurationManager.getInstance().getURIMappingPrefix() + media.getHandle() + "/resolutions/thumbnail/" + media.getName() + "." + ImageUtils.getExtension(media, "thumbnail");
        }
        return this.getReplacementThumbnail();
    }

    public abstract String getReplacementThumbnail();

    protected boolean hasPreview(Content media) {
        if (media != null) {
            try {
                return media.hasNodeData(PREVIEW_NODEDATA_NAME);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return false;
    }

    public String getPreviewImageNodeDataName() {
        return PREVIEW_NODEDATA_NAME;
    }
}

