/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.types.impl;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.NodeData;
import info.magnolia.cms.util.NodeDataUtil;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.types.impl.BaseTypeHandler;
import net.sourceforge.openutils.mgnlmedia.media.utils.IcoUtils;
import net.sourceforge.openutils.mgnlmedia.media.utils.ImageUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.devlib.schmidt.imageinfo.ImageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageTypeHandler
extends BaseTypeHandler {
    private Logger log = LoggerFactory.getLogger(ImageTypeHandler.class);

    public String getThumbnailUrl(Content media) {
        if (!ImageUtils.checkOrCreateResolution(media, "thumbnail", "original")) {
            return "";
        }
        return MediaConfigurationManager.getInstance().getURIMappingPrefix() + media.getHandle() + "/resolutions/thumbnail/" + media.getName() + "." + ImageUtils.getExtension(media, "thumbnail");
    }

    public String getPreviewUrl(Content media) {
        if (!ImageUtils.checkOrCreateResolution(media, "preview", "original")) {
            return "";
        }
        return MediaConfigurationManager.getInstance().getURIMappingPrefix() + media.getHandle() + "/resolutions/preview/" + media.getName() + "." + ImageUtils.getExtension(media, "preview");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onPostSave(Content media) {
        InputStream stream;
        block6: {
            stream = null;
            try {
                NodeData nodeData = this.getOriginalFileNodeData(media);
                stream = this.getOriginalFileNodeData(media).getStream();
                ImageInfo ii = new ImageInfo();
                ii.setInput(stream);
                if (ii.check()) {
                    NodeDataUtil.getOrCreateAndSet((Content)media, (String)"media_bitdepth", (int)ii.getBitsPerPixel());
                    NodeDataUtil.getOrCreateAndSet((Content)media, (String)"media_width", (int)ii.getWidth());
                    NodeDataUtil.getOrCreateAndSet((Content)media, (String)"media_height", (int)ii.getHeight());
                    media.save();
                    break block6;
                }
                if (!StringUtils.equals((String)nodeData.getAttribute("extension"), (String)"ico")) break block6;
                BufferedImage bi = IcoUtils.createBufferedImage(nodeData);
                if (bi != null) {
                    NodeDataUtil.getOrCreateAndSet((Content)media, (String)"media_bitdepth", (int)bi.getColorModel().getPixelSize());
                    NodeDataUtil.getOrCreateAndSet((Content)media, (String)"media_width", (int)bi.getWidth());
                    NodeDataUtil.getOrCreateAndSet((Content)media, (String)"media_height", (int)bi.getHeight());
                    media.save();
                }
                bi.flush();
            }
            catch (Throwable e) {
                try {
                    this.log.warn("Error determining bit depth " + this.getOriginalFileNodeData(media).getHandle() + " " + e.getClass().getName() + " " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        return super.onPostSave(media);
    }
}

