/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.types.impl;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.util.NodeDataUtil;
import java.util.Map;
import net.sourceforge.openutils.mgnlmedia.media.types.impl.MediaWithPreviewImageTypeHandler;
import net.sourceforge.openutils.mgnlmedia.media.utils.MediaMetadataFormatUtils;
import net.sourceforge.openutils.mgnlmedia.media.utils.VideoMedataUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseVideoTypeHandler
extends MediaWithPreviewImageTypeHandler {
    private Logger log = LoggerFactory.getLogger(BaseVideoTypeHandler.class);

    protected abstract VideoMedataUtils.VideoMetaData parseFLVMetaData(Content var1) throws Exception;

    @Override
    public boolean onPostSave(Content media) {
        try {
            VideoMedataUtils.VideoMetaData flvMetaData = null;
            try {
                flvMetaData = this.parseFLVMetaData(media);
            }
            catch (Throwable e) {
                this.log.warn("Error parsing video file " + this.getOriginalFileNodeData(media).getHandle() + " " + e.getClass().getName() + " " + e.getMessage(), e);
            }
            if (flvMetaData != null) {
                NodeDataUtil.getOrCreateAndSet((Content)media, (String)"media_extension", (Object)this.getExtension(media));
                NodeDataUtil.getOrCreateAndSet((Content)media, (String)"media_width", (Object)flvMetaData.getWidth());
                NodeDataUtil.getOrCreateAndSet((Content)media, (String)"media_height", (long)flvMetaData.getHeight());
                NodeDataUtil.getOrCreateAndSet((Content)media, (String)"media_duration", (long)flvMetaData.getDuration());
                NodeDataUtil.getOrCreateAndSet((Content)media, (String)"media_framerate", (Object)flvMetaData.getFrameRate());
                media.save();
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return super.onPostSave(media);
    }

    @Override
    public Map<String, String> getMediaInfo(Content media) {
        long framerate;
        Map<String, String> info = super.getMediaInfo(media);
        long duration = media.getNodeData("media_duration").getLong();
        if (duration > 0L) {
            info.put("media_duration", MediaMetadataFormatUtils.formatDuration(duration));
        }
        if ((framerate = media.getNodeData("media_framerate").getLong()) > 0L) {
            info.put("media_framerate", Long.toString(framerate));
        }
        return info;
    }

    @Override
    public String getReplacementThumbnail() {
        return "/.resources/media/icons/thumb-video.png";
    }
}

