/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.tree;

import info.magnolia.cms.beans.config.ServerConfiguration;
import info.magnolia.cms.exchange.ActivationManagerFactory;
import info.magnolia.cms.gui.control.ContextMenuItem;
import info.magnolia.cms.gui.control.FunctionBarItem;
import info.magnolia.cms.gui.control.Tree;
import info.magnolia.cms.gui.control.TreeColumn;
import info.magnolia.cms.i18n.Messages;
import info.magnolia.module.admininterface.AbstractTreeConfiguration;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaTypeConfiguration;
import net.sourceforge.openutils.mgnlmedia.media.tags.el.MediaEl;

public class MediaModuleTreeConfiguration
extends AbstractTreeConfiguration {
    public void prepareContextMenu(Tree tree, boolean browseMode, HttpServletRequest request) {
        Messages msgs = this.getMessages();
        ContextMenuItem menuNewPage = new ContextMenuItem("newFolder");
        menuNewPage.setLabel(msgs.get("tree.config.menu.newFolder"));
        menuNewPage.setIcon(request.getContextPath() + "/.resources/media/icons/ico16-folder.png");
        menuNewPage.setOnclick(tree.getJavascriptTree() + ".createNode('" + MediaConfigurationManager.FOLDER.getSystemName() + "');");
        menuNewPage.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotNodeData(" + tree.getJavascriptTree() + ")");
        menuNewPage.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotContentNode(" + tree.getJavascriptTree() + ")");
        menuNewPage.addJavascriptCondition("new mgnlTreeMenuItemConditionPermissionWrite(" + tree.getJavascriptTree() + ")");
        ArrayList<ContextMenuItem> menusNewMedia = new ArrayList<ContextMenuItem>();
        for (Map.Entry<String, MediaTypeConfiguration> mtc : MediaConfigurationManager.getInstance().getTypes().entrySet()) {
            ContextMenuItem menuItem = new ContextMenuItem("newMedia-" + mtc.getKey());
            menuItem.setLabel(msgs.get("media.types." + mtc.getValue().getName() + ".load"));
            menuItem.setIcon(request.getContextPath() + mtc.getValue().getMenuIcon());
            menuItem.setOnclick("mgnl.media.createNew(" + tree.getJavascriptTree() + ".selectedNode.id, '" + mtc.getValue().getDialog() + "');");
            menuItem.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotContentNode(" + tree.getJavascriptTree() + ")");
            menuItem.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotRoot(" + tree.getJavascriptTree() + ")");
            menuItem.addJavascriptCondition("new mgnlTreeMenuItemConditionPermissionWrite(" + tree.getJavascriptTree() + ")");
            menusNewMedia.add(menuItem);
        }
        ContextMenuItem menuDelete = new ContextMenuItem("delete");
        menuDelete.setLabel(msgs.get("tree.config.menu.delete"));
        menuDelete.setIcon(request.getContextPath() + "/.resources/icons/16/delete2.gif");
        menuDelete.setOnclick(tree.getJavascriptTree() + ".deleteNode();");
        menuDelete.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotRoot(" + tree.getJavascriptTree() + ")");
        menuDelete.addJavascriptCondition("new mgnlTreeMenuItemConditionPermissionWrite(" + tree.getJavascriptTree() + ")");
        ContextMenuItem menuCopy = new ContextMenuItem("copy");
        menuCopy.setLabel(msgs.get("tree.config.menu.copy"));
        menuCopy.setIcon(request.getContextPath() + "/.resources/icons/16/copy.gif");
        menuCopy.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotRoot(" + tree.getJavascriptTree() + ")");
        menuCopy.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotNodeData(" + tree.getJavascriptTree() + ")");
        menuCopy.setOnclick(tree.getJavascriptTree() + ".copyNode();");
        ContextMenuItem menuCut = new ContextMenuItem("move");
        menuCut.setLabel(msgs.get("tree.config.menu.move"));
        menuCut.setIcon(request.getContextPath() + "/.resources/icons/16/up_down.gif");
        menuCut.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotRoot(" + tree.getJavascriptTree() + ")");
        menuCut.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotNodeData(" + tree.getJavascriptTree() + ")");
        menuCut.setOnclick(tree.getJavascriptTree() + ".cutNode();");
        menuCut.addJavascriptCondition("new mgnlTreeMenuItemConditionPermissionWrite(" + tree.getJavascriptTree() + ")");
        ContextMenuItem menuActivateExcl = new ContextMenuItem("activate");
        menuActivateExcl.setLabel(msgs.get("tree.config.menu.activate"));
        menuActivateExcl.setIcon(request.getContextPath() + "/.resources/icons/16/arrow_right_green.gif");
        menuActivateExcl.setOnclick(tree.getJavascriptTree() + ".activateNode(" + 2 + ",false);");
        menuActivateExcl.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotRoot(" + tree.getJavascriptTree() + ")");
        menuActivateExcl.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotNodeData(" + tree.getJavascriptTree() + ")");
        menuActivateExcl.addJavascriptCondition("new mgnlTreeMenuItemConditionPermissionWrite(" + tree.getJavascriptTree() + ")");
        ContextMenuItem menuActivate = new ContextMenuItem("activateInclSubs");
        menuActivate.setLabel(msgs.get("tree.config.menu.activateInclSubs"));
        menuActivate.setIcon(request.getContextPath() + "/.resources/icons/16/arrow_right_green.gif");
        menuActivate.setOnclick(tree.getJavascriptTree() + ".activateNode(" + 2 + ",true);");
        menuActivate.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotRoot(" + tree.getJavascriptTree() + ")");
        menuActivate.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotNodeData(" + tree.getJavascriptTree() + ")");
        menuActivate.addJavascriptCondition("new mgnlTreeMenuItemConditionPermissionWrite(" + tree.getJavascriptTree() + ")");
        ContextMenuItem menuDeactivate = new ContextMenuItem("deactivate");
        menuDeactivate.setLabel(msgs.get("tree.config.menu.deactivate"));
        menuDeactivate.setIcon(request.getContextPath() + "/.resources/icons/16/arrow_left_red.gif");
        menuDeactivate.setOnclick(tree.getJavascriptTree() + ".deactivateNode(" + 3 + ");");
        menuDeactivate.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotRoot(" + tree.getJavascriptTree() + ")");
        menuDeactivate.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotNodeData(" + tree.getJavascriptTree() + ")");
        menuDeactivate.addJavascriptCondition("new mgnlTreeMenuItemConditionPermissionWrite(" + tree.getJavascriptTree() + ")");
        ContextMenuItem menuLoadZip = new ContextMenuItem("loadzip");
        menuLoadZip.setLabel(msgs.get("media.loadzip"));
        menuLoadZip.setIcon(request.getContextPath() + "/.resources/media/icons/ico16-zip.png");
        menuLoadZip.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotRoot(" + tree.getJavascriptTree() + ")");
        menuLoadZip.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotNodeData(" + tree.getJavascriptTree() + ")");
        menuLoadZip.setOnclick("parent.uploadzip(" + tree.getJavascriptTree() + ");");
        menuLoadZip.addJavascriptCondition("new mgnlTreeMenuItemConditionPermissionWrite(" + tree.getJavascriptTree() + ")");
        if (!ActivationManagerFactory.getActivationManager().hasAnyActiveSubscriber()) {
            menuActivate.addJavascriptCondition("new mgnlTreeMenuItemConditionBoolean(false)");
            menuActivateExcl.addJavascriptCondition("new mgnlTreeMenuItemConditionBoolean(false)");
            menuDeactivate.addJavascriptCondition("new mgnlTreeMenuItemConditionBoolean(false)");
        }
        if (!browseMode) {
            tree.addMenuItem(menuNewPage);
            for (ContextMenuItem it : menusNewMedia) {
                tree.addMenuItem(it);
            }
            tree.addSeparator();
            tree.addMenuItem(menuLoadZip);
            tree.addSeparator();
            tree.addMenuItem(menuDelete);
            tree.addSeparator();
            tree.addMenuItem(menuCut);
            tree.addMenuItem(menuCopy);
            if (!MediaEl.module().isSingleinstance()) {
                tree.addSeparator();
                tree.addMenuItem(menuActivateExcl);
                tree.addMenuItem(menuActivate);
                tree.addMenuItem(menuDeactivate);
            }
        } else {
            tree.addMenuItem(ContextMenuItem.getRefreshMenuItem((Tree)tree, (Messages)msgs, (HttpServletRequest)request));
        }
    }

    public void prepareFunctionBar(Tree tree, boolean browseMode, HttpServletRequest request) {
        tree.addFunctionBarItem(FunctionBarItem.getRefreshFunctionBarItem((Tree)tree, (Messages)this.getMessages(), (HttpServletRequest)request));
    }

    public void prepareTree(Tree tree, boolean browseMode, HttpServletRequest request) {
        Messages msgs = this.getMessages();
        tree.addItemType(MediaConfigurationManager.FOLDER.getSystemName(), "/.resources/media/icons/ico16-folder.png");
        TreeColumn column0 = TreeColumn.createLabelColumn((Tree)tree, (String)msgs.get("tree.media.folders"), (boolean)true);
        column0.setWidth(3);
        tree.addColumn(column0);
        if (!browseMode && !MediaEl.module().isSingleinstance() && (ServerConfiguration.getInstance().isAdmin() || ActivationManagerFactory.getActivationManager().hasAnyActiveSubscriber())) {
            TreeColumn columnIcons = TreeColumn.createIconColumn((Tree)tree, (String)msgs.get("tree.config.status"), null);
            columnIcons.setCssClass("");
            columnIcons.setWidth(1);
            columnIcons.setIconsActivation(true);
            columnIcons.setIconsPermission(true);
            tree.addColumn(columnIcons);
        }
    }
}

