/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.tags.el;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import info.magnolia.cms.beans.runtime.FileProperties;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.NodeData;
import info.magnolia.cms.i18n.I18nContentWrapper;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.cms.util.NodeMapWrapper;
import info.magnolia.context.MgnlContext;
import info.magnolia.module.ModuleRegistry;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaTypeConfiguration;
import net.sourceforge.openutils.mgnlmedia.media.lifecycle.MediaModule;
import net.sourceforge.openutils.mgnlmedia.media.utils.ImageUtils;
import net.sourceforge.openutils.mgnlmedia.playlist.utils.PlaylistIterateUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MediaEl {
    private static MediaConfigurationManager mcm = MediaConfigurationManager.getInstance();
    private static Logger log = LoggerFactory.getLogger(MediaEl.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static MediaModule module() {
        return (MediaModule)ModuleRegistry.Factory.getInstance().getModuleInstance("media");
    }

    public static Content node(Object obj) {
        Content content;
        block13: {
            if (obj == null) {
                return null;
            }
            content = null;
            if (obj instanceof String) {
                String mediaIdentifier = (String)obj;
                if (StringUtils.isBlank((String)mediaIdentifier)) {
                    return null;
                }
                HierarchyManager hm = MgnlContext.getHierarchyManager((String)"media");
                try {
                    if (mediaIdentifier.startsWith("/")) {
                        if (hm.isExist(mediaIdentifier)) {
                            content = hm.getContent(mediaIdentifier);
                        }
                        break block13;
                    }
                    content = hm.getContentByUUID(StringUtils.trim((String)mediaIdentifier));
                }
                catch (ItemNotFoundException e) {
                    log.debug("Node \"" + mediaIdentifier + "\" not found");
                }
                catch (RepositoryException e) {
                    log.error(((Object)((Object)e)).getClass().getName() + " getting node \"" + mediaIdentifier + "\"", (Throwable)e);
                }
            } else if (obj instanceof Content) {
                content = (Content)obj;
            }
        }
        if (content != null && !(content instanceof NodeMapWrapper)) {
            Content currentpage = null;
            if (MgnlContext.isWebContext()) {
                currentpage = MgnlContext.getAggregationState().getMainContent();
            }
            if (currentpage == null) {
                currentpage = content;
            }
            content = new NodeMapWrapper((Content)new I18nContentWrapper(content), currentpage.getHandle());
        }
        return content;
    }

    public static String url(Object media) {
        return MediaEl.urlParams(MediaEl.node(media), Collections.<String, String>emptyMap());
    }

    public static String urlParams(Object mediaref, Map<String, String> options) {
        Content media = MediaEl.node(mediaref);
        if (media == null) {
            return null;
        }
        MediaTypeConfiguration mtc = mcm.getMediaTypeConfigurationFromMedia(media);
        if (mtc == null || mtc.getHandler() == null) {
            return null;
        }
        return mtc.getHandler().getUrl(media, options);
    }

    public static String thumbnail(Object mediaref) {
        Content media = MediaEl.node(mediaref);
        if (media == null) {
            return null;
        }
        MediaTypeConfiguration mtc = mcm.getMediaTypeConfigurationFromMedia(media);
        if (mtc == null || mtc.getHandler() == null) {
            return null;
        }
        return mtc.getHandler().getThumbnailUrl(media);
    }

    public static String type(Object media) {
        if (media == null) {
            return null;
        }
        return NodeDataUtil.getString((Content)MediaEl.node(media), (String)"type");
    }

    public static String[] resolutions(Object mediaref) {
        Content media = MediaEl.node(mediaref);
        ArrayList<String> res = new ArrayList<String>();
        Content resolutions = MediaEl.getResolutionsNode(media);
        Collection nodeDataCollection = resolutions.getNodeDataCollection();
        for (NodeData item : nodeDataCollection) {
            if (!item.getName().startsWith("res-")) continue;
            if (item.getAttribute(ImageUtils.RESOLUTION_PROPERTY) != null) {
                res.add(item.getAttribute(ImageUtils.RESOLUTION_PROPERTY));
                continue;
            }
            res.add(StringUtils.substringAfter((String)item.getName(), (String)"-"));
        }
        return res.toArray(new String[res.size()]);
    }

    public static String urlres(Object mediaref, String resolution) {
        Content media = MediaEl.node(mediaref);
        if (media == null) {
            return null;
        }
        if (media.getNodeData("original").getType() == 2) {
            FileProperties prop = new FileProperties(media, "original");
            Integer width = NumberUtils.toInt((String)prop.getProperty("width"));
            Integer height = NumberUtils.toInt((String)prop.getProperty("height"));
            Point size = ImageUtils.parseForSize(resolution);
            if (width == size.x && height == size.y) {
                return mcm.getURIMappingPrefix() + prop.getProperty("path");
            }
        }
        if (!ImageUtils.checkOrCreateResolution(media, resolution, null)) {
            return null;
        }
        Content resolutions = MediaEl.getResolutionsNode(media);
        try {
            String resString = "res-" + ImageUtils.getResolutionPath(resolution);
            if (resolutions != null && resolutions.hasNodeData(resString)) {
                String resPath = new FileProperties(resolutions, resString).getProperty("path");
                return mcm.getURIMappingPrefix() + resPath;
            }
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static int[] size(Object mediaref, String resolution) {
        Content media = MediaEl.node(mediaref);
        if (media != null) {
            NodeData res = null;
            if ("original".equals(resolution)) {
                res = media.getNodeData("original");
            } else {
                Content resolutions = MediaEl.getResolutionsNode(media);
                if (resolutions != null) {
                    try {
                        if (resolutions.hasNodeData(ImageUtils.getResolutionPath("res-" + resolution))) {
                            res = resolutions.getNodeData(ImageUtils.getResolutionPath("res-" + resolution));
                        }
                    }
                    catch (RepositoryException e) {
                        res = null;
                    }
                }
            }
            if (res != null) {
                return new int[]{NumberUtils.toInt((String)res.getAttribute("width")), NumberUtils.toInt((String)res.getAttribute("height"))};
            }
            res = media.getNodeData("original");
            Point size = ImageUtils.parseForSize(resolution);
            if (NumberUtils.toInt((String)res.getAttribute("width")) == size.x && NumberUtils.toInt((String)res.getAttribute("height")) == size.y) {
                return new int[]{size.x, size.y};
            }
        }
        return new int[]{-1, -1};
    }

    public static String preview(Object mediaref) {
        Content media = MediaEl.node(mediaref);
        if (media == null) {
            return null;
        }
        MediaTypeConfiguration mtc = mcm.getMediaTypeConfigurationFromMedia(media);
        if (mtc == null || mtc.getHandler() == null) {
            return null;
        }
        return mtc.getHandler().getPreviewUrl(media);
    }

    public static String[] usedInWebPages(Object mediaref) {
        Content media = MediaEl.node(mediaref);
        if (media == null) {
            log.warn("findMediaUsedInWebPages called with a null media");
            return new String[0];
        }
        try {
            List<String> retVal = mcm.getUsedInWebPages(media.getUUID());
            return CollectionUtils.isNotEmpty(retVal) ? retVal.toArray(new String[retVal.size()]) : EMPTY_STRING_ARRAY;
        }
        catch (InvalidQueryException e) {
            log.error("JCR Query returned the following error: ", (Throwable)e);
        }
        catch (RepositoryException e) {
            log.error("JCR Repository returned the following error: ", (Throwable)e);
        }
        return EMPTY_STRING_ARRAY;
    }

    public static Object property(Object mediaref, String property) {
        Content media = MediaEl.node(mediaref);
        try {
            if (media == null || !media.hasNodeData(property)) {
                return null;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return MediaEl.getValueAsObject(media.getNodeData(property).getValue());
    }

    public static Integer width(Object media) {
        Number longproperty = (Number)MediaEl.property(media, "media_width");
        if (longproperty != null) {
            return longproperty.intValue();
        }
        return null;
    }

    public static Integer height(Object media) {
        Number longproperty = (Number)MediaEl.property(media, "media_height");
        if (longproperty != null) {
            return longproperty.intValue();
        }
        return null;
    }

    private static Object getValueAsObject(Value value) {
        try {
            switch (value.getType()) {
                case 1: {
                    return value.getString();
                }
                case 4: {
                    return value.getDouble();
                }
                case 3: {
                    return value.getLong();
                }
                case 6: {
                    return value.getBoolean();
                }
                case 5: {
                    return value.getDate();
                }
            }
            return null;
        }
        catch (Exception e) {
            log.debug("Exception caught: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected static Content getResolutionsNode(Content media) {
        Content resolutions = null;
        try {
            if (media.hasContent("resolutions")) {
                resolutions = media.getContent("resolutions");
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return resolutions;
    }

    public static Iterator<Content> mediaNodesInPlaylist(Object obj) {
        Content playlistNode;
        block10: {
            playlistNode = null;
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                String identifier = (String)obj;
                if (StringUtils.isBlank((String)identifier)) {
                    return null;
                }
                HierarchyManager hm = MgnlContext.getHierarchyManager((String)"playlists");
                try {
                    if (identifier.startsWith("/")) {
                        if (hm.isExist(identifier)) {
                            playlistNode = hm.getContent(identifier);
                        }
                        break block10;
                    }
                    playlistNode = hm.getContentByUUID(StringUtils.trim((String)identifier));
                }
                catch (ItemNotFoundException e) {
                    log.debug("Node \"" + identifier + "\" not found");
                }
                catch (RepositoryException e) {
                    log.error(((Object)((Object)e)).getClass().getName() + " getting node \"" + identifier + "\"", (Throwable)e);
                }
            } else if (obj instanceof Content) {
                playlistNode = (Content)obj;
            }
        }
        Iterator iter = Iterators.transform(PlaylistIterateUtils.iterate(playlistNode), (Function)new Function<PlaylistIterateUtils.MediaNodeAndEntryPath, Content>(){

            public Content apply(PlaylistIterateUtils.MediaNodeAndEntryPath from) {
                return from.getMediaNode();
            }
        });
        return Iterators.filter((Iterator)iter, (Predicate)Predicates.notNull());
    }

    public static String replaceParam(String param, String newValue) {
        HttpServletRequest req = MgnlContext.getWebContext().getRequest();
        String url = "?" + (StringUtils.isNotBlank((String)req.getQueryString()) ? MgnlContext.getWebContext().getRequest().getQueryString() : "");
        if (url.indexOf("?" + param + "=") >= 0 || url.indexOf("&" + param + "=") >= 0) {
            int index = 1;
            if (url.indexOf("&" + param + "=") >= 0) {
                index = url.indexOf("&" + param + "=");
            }
            url = StringUtils.substring((String)url, (int)0, (int)index) + StringUtils.substringAfter((String)StringUtils.substring((String)url, (int)(index + 1)), (String)"&");
        }
        if (StringUtils.isNotBlank((String)newValue)) {
            url = url + (url.endsWith("?") ? "" : "&") + param + "=" + newValue;
        }
        return url;
    }

    @Deprecated
    public static Content getNode(Object obj) {
        log.warn("\"getNode()\" has been deprecated, please use \"node()\"");
        return MediaEl.node(obj);
    }

    @Deprecated
    public static String getDescription(Content media, Locale locale) {
        log.warn("\"getDescription()\" has been deprecated, please use \"descLoc()\"");
        return MediaEl.descLoc(media, locale);
    }

    @Deprecated
    public static String getDescription(Content media) {
        log.warn("\"getDescription()\" has been deprecated, please use \"desc()\"");
        return MediaEl.desc(media);
    }

    @Deprecated
    public static String getTitle(Content media, Locale locale) {
        log.warn("\"getTitle()\" has been deprecated, please use \"titleLoc()\"");
        return MediaEl.titleLoc(media, locale);
    }

    @Deprecated
    public static String getTitle(Content media) {
        log.warn("\"getTitle()\" has been deprecated, please use \"title()\"");
        return MediaEl.title(media);
    }

    @Deprecated
    public static String getUrl(Content media) {
        log.warn("\"getUrl()\" has been deprecated, please use \"url()\"");
        return MediaEl.url(media);
    }

    @Deprecated
    public static String getUrl2(Content media, Map<String, String> options) {
        log.warn("\"url2()\" has been deprecated, please use \"urlParams()\"");
        return MediaEl.urlParams(media, options);
    }

    @Deprecated
    public static String getResolutionUrl(Content media, String resolution) {
        log.warn("\"getResolutionUrl()\" has been deprecated, please use \"urlres()\"");
        return MediaEl.urlres(media, resolution);
    }

    @Deprecated
    public static String[] listResolutions(Content media) {
        log.warn("\"listResolutions()\" has been deprecated, please use \"resolutions()\"");
        return MediaEl.resolutions(media);
    }

    @Deprecated
    public static String getThumbnail(Content media) {
        log.warn("\"getThumbnail()\" has been deprecated, please use \"thumbnail()\"");
        return MediaEl.thumbnail(media);
    }

    @Deprecated
    public static String getPreview(Content media) {
        log.warn("\"getPreview()\" has been deprecated, please use \"preview()\"");
        return MediaEl.preview(media);
    }

    @Deprecated
    public static String getType(Content media) {
        log.warn("\"getType()\" has been deprecated, please use \"type()\"");
        return MediaEl.type(media);
    }

    @Deprecated
    public static int[] getSize(Content media, String resolution) {
        log.warn("\"getSize()\" has been deprecated, please use \"size()\"");
        return MediaEl.size(media, resolution);
    }

    @Deprecated
    public static String[] findMediaUsedInWebPages(Content media) {
        log.warn("\"findMediaUsedInWebPages()\" has been deprecated, please use \"usedInWebPages()\"");
        return MediaEl.usedInWebPages(media);
    }

    @Deprecated
    public static String descLoc(Content media, Locale locale) {
        MediaTypeConfiguration mtc;
        log.warn("\"descLoc()\" has been deprecated, please check javadocs");
        if (media == null) {
            return null;
        }
        if (locale != null) {
            MgnlContext.setLocale((Locale)locale);
        }
        if ((mtc = mcm.getMediaTypeConfigurationFromMedia(media)) == null || mtc.getHandler() == null) {
            return null;
        }
        return mtc.getHandler().getDescription(media);
    }

    @Deprecated
    public static String titleLoc(Content media, Locale locale) {
        MediaTypeConfiguration mtc;
        log.warn("\"titleLoc()\" has been deprecated, please check javadocs");
        if (media == null) {
            return null;
        }
        if (locale != null) {
            MgnlContext.setLocale((Locale)locale);
        }
        if ((mtc = mcm.getMediaTypeConfigurationFromMedia(media)) == null || mtc.getHandler() == null) {
            return null;
        }
        return mtc.getHandler().getTitle(media);
    }

    @Deprecated
    public static String[] tagsLoc(Content media, Locale locale) {
        MediaTypeConfiguration mtc;
        log.warn("\"tagsLoc()\" has been deprecated, please check javadocs");
        if (media == null) {
            return null;
        }
        if (locale != null) {
            MgnlContext.setLocale((Locale)locale);
        }
        if ((mtc = mcm.getMediaTypeConfigurationFromMedia(media)) == null || mtc.getHandler() == null) {
            return null;
        }
        String tags = mtc.getHandler().getTags(media);
        if (tags == null) {
            return null;
        }
        return StringUtils.split((String)tags, (String)",");
    }

    @Deprecated
    public static String desc(Content media) {
        log.warn("\"desc()\" has been deprecated, please check javadocs");
        return MediaEl.descLoc(media, null);
    }

    @Deprecated
    public static String title(Content media) {
        log.warn("\"title()\" has been deprecated, please check javadocs");
        return MediaEl.titleLoc(media, null);
    }

    @Deprecated
    public static String[] tags(Content media) {
        log.warn("\"tags()\" has been deprecated, please check javadocs");
        return MediaEl.tagsLoc(media, null);
    }
}

