/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.setup;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.TaskExecutionException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;

public class RemoveExtensionFromType
extends AbstractRepositoryTask {
    private final String extension;
    private final String mediatype;
    private final String control;

    public RemoveExtensionFromType(String extension, String mediatype, String control) {
        super("Adding " + extension + " extension to mediatype " + mediatype, "Adding " + extension + " extension to mediatype " + mediatype);
        this.extension = extension;
        this.mediatype = mediatype;
        this.control = control;
    }

    protected void doExecute(InstallContext ctx) throws RepositoryException, TaskExecutionException {
        ArrayList<String> exts;
        String extensions;
        Content mediatypenode;
        HierarchyManager hm = ctx.getHierarchyManager("config");
        String nodePath = "/modules/media/mediatypes/" + this.mediatype;
        try {
            mediatypenode = hm.getContent(nodePath);
            extensions = mediatypenode.getNodeData("extensions").getString();
            if (StringUtils.contains((String)extensions, (String)this.extension)) {
                exts = new ArrayList<String>(Arrays.asList(StringUtils.split((String)extensions, (String)",")));
                exts.remove(this.extension);
                mediatypenode.setNodeData("extensions", StringUtils.join(exts, (String)","));
            }
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        try {
            mediatypenode = hm.getContent(this.control);
            extensions = mediatypenode.getNodeData("extensions").getString();
            if (StringUtils.contains((String)extensions, (String)this.extension)) {
                exts = new ArrayList<String>(Arrays.asList(StringUtils.split((String)extensions, (String)",")));
                exts.remove(this.extension);
                mediatypenode.setNodeData("extensions", StringUtils.join(exts, (String)","));
            }
        }
        catch (RepositoryException e) {
            // empty catch block
        }
    }
}

