/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.setup;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.NodeData;
import info.magnolia.context.MgnlContext;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.Task;
import info.magnolia.module.delta.TaskExecutionException;
import java.io.InputStream;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResult;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.DirectJcrQuery;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.JCRCriteriaFactory;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.ResultIterator;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveOriginalNodeTask
implements Task {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public String getName() {
        return "file store nodedata name updater";
    }

    public String getDescription() {
        return "update custom nodedata names (where original files are stored) to \"original\"";
    }

    public void execute(InstallContext installContext) throws TaskExecutionException {
        HierarchyManager mgr = installContext.getHierarchyManager("media");
        try {
            MoveOriginalNodeTask.reset(mgr, "image", "image");
            MoveOriginalNodeTask.reset(mgr, "video", "video");
            MoveOriginalNodeTask.reset(mgr, "audio", "audio");
        }
        catch (RepositoryException ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public static void execute() throws RepositoryException {
        HierarchyManager mgr = MgnlContext.getHierarchyManager((String)"media");
        MoveOriginalNodeTask.reset(mgr, "image", "image");
        MoveOriginalNodeTask.reset(mgr, "video", "video");
        MoveOriginalNodeTask.reset(mgr, "audio", "audio");
    }

    public static void reset(HierarchyManager queryManager, String type, String nodedataOldName) throws RepositoryException {
        DirectJcrQuery query = JCRCriteriaFactory.createDirectJcrQuery((HierarchyManager)queryManager, (String)("//*[@jcr:primaryType = '" + MediaConfigurationManager.MEDIA.getSystemName() + "' and " + nodedataOldName + " and @type='" + type + "']"), (String)"xpath");
        AdvancedResult result = query.execute();
        ResultIterator items = result.getItems();
        while (items.hasNext()) {
            Content media = (Content)items.next();
            NodeData nd = media.getNodeData(nodedataOldName);
            Value value = nd.getValue();
            if (value != null) {
                InputStream stream = value.getStream();
                NodeData ndNew = media.createNodeData("original", (Object)stream);
                for (String attributeName : (List)nd.getAttributeNames()) {
                    try {
                        ndNew.setAttribute(attributeName, nd.getAttribute(attributeName));
                    }
                    catch (ConstraintViolationException ex) {}
                }
                IOUtils.closeQuietly((InputStream)stream);
                nd.delete();
            }
            media.save();
        }
    }
}

