/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.setup;

import info.magnolia.cms.core.SystemProperty;
import info.magnolia.module.InstallContext;
import info.magnolia.module.ModuleRegistry;
import info.magnolia.module.delta.SetupModuleRepositoriesTask;
import info.magnolia.module.delta.Task;
import it.openutils.mgnltasks.BootstrapMissingNodesTask;
import it.openutils.mgnltasks.ChangeExistingPropertyTask;
import it.openutils.mgnltasks.CreateMissingPropertyTask;
import it.openutils.mgnltasks.NodeSortTask;
import it.openutils.mgnltasks.SamplesExtractionTask;
import it.openutils.mgnltasks.SimpleModuleVersionHandler;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.openutils.mgnlmedia.media.setup.AddExtensionToType;
import net.sourceforge.openutils.mgnlmedia.media.setup.ConditionallySubscribeMediaRepositoriesTask;
import net.sourceforge.openutils.mgnlmedia.media.setup.MoveHandlerNodedataToNode;
import net.sourceforge.openutils.mgnlmedia.media.setup.RemoveExtensionFromType;
import net.sourceforge.openutils.mgnlmedia.media.setup.SetupModuleRepositoriesWithoutSubscriberTask;
import net.sourceforge.openutils.mgnlmedia.media.types.impl.ExternalVideoTypeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaModuleVersionHandler
extends SimpleModuleVersionHandler {
    protected List<Task> getBasicInstallTasks(InstallContext installContext) {
        List basicInstallTasks = super.getBasicInstallTasks(installContext);
        for (int j = 0; j < basicInstallTasks.size(); ++j) {
            if (!(basicInstallTasks.get(j) instanceof SetupModuleRepositoriesTask)) continue;
            basicInstallTasks.remove(j);
            basicInstallTasks.add(j, new SetupModuleRepositoriesWithoutSubscriberTask());
            break;
        }
        basicInstallTasks.add(new ConditionallySubscribeMediaRepositoriesTask());
        return basicInstallTasks;
    }

    protected List<Task> getStartupTasks(InstallContext installContext) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        if (SystemProperty.getBooleanProperty((String)"magnolia.bootstrap.samples")) {
            tasks.add((Task)new SamplesExtractionTask());
        }
        tasks.add((Task)new CreateMissingPropertyTask("config", "/modules/media/config", "singleinstance", (Object)Boolean.FALSE));
        tasks.add((Task)new CreateMissingPropertyTask("config", "/modules/media/config", "player", (Object)"jwplayer5"));
        tasks.add((Task)new CreateMissingPropertyTask("config", "/modules/media/config", "folderViewItemsPerPage", (Object)10L));
        tasks.add((Task)new CreateMissingPropertyTask("config", "/modules/media/mediatypes/image", "enabled", (Object)Boolean.TRUE));
        tasks.add((Task)new CreateMissingPropertyTask("config", "/modules/media/mediatypes/video", "enabled", (Object)Boolean.TRUE));
        tasks.add((Task)new CreateMissingPropertyTask("config", "/modules/media/mediatypes/youtube", "enabled", (Object)Boolean.TRUE));
        tasks.add((Task)new CreateMissingPropertyTask("config", "/modules/media/mediatypes/audio", "enabled", (Object)Boolean.TRUE));
        tasks.add((Task)new ChangeExistingPropertyTask("config", "/modules/media/mediatypes/youtube", "menuIcon", (Object)"net.sourceforge.openutils.mgnlmedia.media.types.impl.YouTubeVideoTypeHandler", (Object)ExternalVideoTypeHandler.class.getName()));
        tasks.add((Task)new ChangeExistingPropertyTask("config", "/modules/media/mediatypes/youtube", "menuIcon", (Object)"/.resources/media/icons/film.gif", (Object)"/.resources/media/icons/type-youtube.png"));
        tasks.add((Task)new ChangeExistingPropertyTask("config", "/modules/media/mediatypes/audio", "menuIcon", (Object)"/.resources/media/icons/audio.gif", (Object)"/.resources/media/icons/type-audio.png"));
        tasks.add((Task)new ChangeExistingPropertyTask("config", "/modules/media/mediatypes/video", "menuIcon", (Object)"/.resources/media/icons/film.gif", (Object)"/.resources/media/icons/type-video.png"));
        tasks.add((Task)new ChangeExistingPropertyTask("config", "/modules/media/mediatypes/image", "menuIcon", (Object)"/.resources/media/icons/image16.gif", (Object)"/.resources/media/icons/type-image.png"));
        tasks.add((Task)new MoveHandlerNodedataToNode());
        tasks.add((Task)new NodeSortTask("config", "/modules/media/mediatypes", "order"));
        tasks.add((Task)new CreateMissingPropertyTask("config", "/modules/media/mediatypes/youtube/handler", "parseremotefiles", (Object)Boolean.TRUE));
        tasks.add((Task)new AddExtensionToType("jpeg", "image", "/modules/media/dialogs/mediaImageDlg/tabImage/original"));
        tasks.add((Task)new AddExtensionToType("ico", "image", "/modules/media/dialogs/mediaImageDlg/tabImage/original"));
        tasks.add((Task)new AddExtensionToType("mp4", "video", "/modules/media/dialogs/mediaVideoDlg/tabVideo/original"));
        tasks.add((Task)new AddExtensionToType("mpv", "video", "/modules/media/dialogs/mediaVideoDlg/tabVideo/original"));
        tasks.add((Task)new AddExtensionToType("ogv", "video", "/modules/media/dialogs/mediaVideoDlg/tabVideo/original"));
        tasks.add((Task)new RemoveExtensionFromType("swf", "video", "/modules/media/dialogs/mediaVideoDlg/tabVideo/original"));
        if (this.isModuleInstalled("standard-templating-kit")) {
            tasks.add((Task)new BootstrapMissingNodesTask("media-stk"));
            tasks.add((Task)new ChangeExistingPropertyTask("config", "/modules/standard-templating-kit/template-renderers/stk", "renderer", (Object)"net.sourceforge.openutils.mgnlmedia.freemarker.SktSimpleMediaTemplateRenderer", (Object)"info.magnolia.module.templatingkit.renderers.STKTemplateRenderer"));
            tasks.add((Task)new ChangeExistingPropertyTask("config", "/modules/standard-templating-kit/paragraph-renderers/stk", "class", (Object)"net.sourceforge.openutils.mgnlmedia.freemarker.SktSimpleMediaParagraphRenderer", (Object)"info.magnolia.module.templatingkit.renderers.STKParagraphRenderer"));
        }
        if (this.isModuleInstalled("extended-templating-kit")) {
            tasks.add((Task)new BootstrapMissingNodesTask("media-etk"));
        }
        tasks.add((Task)new ChangeExistingPropertyTask("config", "/modules/adminInterface/config/menu/media/playlists", "icon", (Object)"/.resources/media/icons/ico16-playlist.png", (Object)"/.resources/media/icons/ico16-playlists.png"));
        tasks.add((Task)new ChangeExistingPropertyTask("config", "/modules/adminInterface/config/menu/media/playlists", "label", (Object)"Playlists", (Object)"media.menu.playlists"));
        return tasks;
    }

    private boolean isModuleInstalled(String module) {
        try {
            return ModuleRegistry.Factory.getInstance().getDefinition(module) != null;
        }
        catch (IllegalArgumentException e) {
            this.log.debug("Module {} not installed ({} {})", new Object[]{module, e.getClass().getName(), e.getMessage()});
            return false;
        }
    }
}

