/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.setup;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.exchange.ActivationManager;
import info.magnolia.cms.exchange.ActivationManagerFactory;
import info.magnolia.cms.exchange.Subscriber;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractTask;
import info.magnolia.module.delta.TaskExecutionException;
import info.magnolia.module.model.ModuleDefinition;
import info.magnolia.module.model.RepositoryDefinition;
import java.util.Collection;
import java.util.List;
import javax.jcr.RepositoryException;

public class ConditionallySubscribeMediaRepositoriesTask
extends AbstractTask {
    public ConditionallySubscribeMediaRepositoriesTask() {
        super("Register workspaces for activation", "Register workspaces for activation.");
    }

    public void execute(InstallContext ctx) throws TaskExecutionException {
        boolean singleinstance = false;
        Content moduleConfigNode = ContentUtil.getContent((String)"config", (String)"/modules/media/config");
        if (moduleConfigNode != null) {
            singleinstance = moduleConfigNode.getNodeData("singleinstance").getBoolean();
        }
        if (singleinstance) {
            return;
        }
        ModuleDefinition def = ctx.getCurrentModuleDefinition();
        Collection repositories = def.getRepositories();
        for (RepositoryDefinition repDef : repositories) {
            List workspaces = repDef.getWorkspaces();
            for (String workspace : workspaces) {
                this.subscribeRepository(workspace);
            }
        }
    }

    private void subscribeRepository(String repository) throws TaskExecutionException {
        ActivationManager sManager = ActivationManagerFactory.getActivationManager();
        Collection subscribers = sManager.getSubscribers();
        for (Subscriber subscriber : subscribers) {
            if (subscriber.isSubscribed("/", repository)) continue;
            Content subscriptionsNode = ContentUtil.getContent((String)"config", (String)(sManager.getConfigPath() + "/" + subscriber.getName() + "/subscriptions"));
            try {
                Content newSubscription = subscriptionsNode.createContent(repository, ItemType.CONTENTNODE);
                newSubscription.createNodeData("toURI").setValue("/");
                newSubscription.createNodeData("repository").setValue(repository);
                newSubscription.createNodeData("fromURI").setValue("/");
            }
            catch (RepositoryException re) {
                throw new TaskExecutionException("wasn't able to subscribe repository [" + repository + "]", (Throwable)re);
            }
        }
    }
}

