/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.save;

import info.magnolia.cms.beans.runtime.MultipartForm;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.core.Path;
import info.magnolia.cms.security.AccessDeniedException;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.module.admininterface.FieldSaveHandler;
import java.util.Enumeration;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiddenParametersSaveHandler
implements FieldSaveHandler {
    private Logger log = LoggerFactory.getLogger(HiddenParametersSaveHandler.class);

    public void save(Content parentNode, Content configNode, String name, MultipartForm form, int type, int valueType, int isRichEditValue, int encoding) throws RepositoryException, AccessDeniedException {
        if (parentNode.hasContent(name)) {
            parentNode.getContent(name).delete();
        }
        Content node = parentNode.createContent(name, ItemType.CONTENTNODE);
        Enumeration paramNames = form.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (!StringUtils.startsWith((String)paramName, (String)(name + "."))) continue;
            String[] paramValues = form.getParameterValues(paramName);
            Content paramNode = node.createContent(Path.getUniqueLabel((Content)node, (String)"0"), ItemType.CONTENTNODE);
            paramNode.setNodeData("name", StringUtils.removeStart((String)paramName, (String)(name + ".")));
            Value[] jcrValues = new Value[paramValues.length];
            for (int i = 0; i < paramValues.length; ++i) {
                jcrValues[i] = NodeDataUtil.createValue((String)paramValues[i], (int)1);
            }
            paramNode.setNodeData("value", jcrValues);
        }
    }
}

