/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.pages;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModelException;
import info.magnolia.cms.i18n.Messages;
import info.magnolia.cms.i18n.MessagesUtil;
import info.magnolia.cms.util.RequestFormUtil;
import info.magnolia.module.admininterface.TemplatedMVCHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaTypeConfiguration;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagesTemplatedMVCHandler
extends TemplatedMVCHandler {
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected TemplateMethodModel getStatic = new GetStaticMethodModel();
    private Messages mediaTypesExtendedMsgs;

    public MessagesTemplatedMVCHandler(String name, HttpServletRequest request, HttpServletResponse response) {
        super(name, request, response);
    }

    public Messages getMsgs() {
        if (this.mediaTypesExtendedMsgs == null) {
            Map<String, MediaTypeConfiguration> types = MediaConfigurationManager.getInstance().getTypes();
            ArrayList<String> basenames = new ArrayList<String>();
            basenames.add(this.getI18nBasename());
            for (MediaTypeConfiguration typeConfig : types.values()) {
                String basename = typeConfig.getI18nBasename();
                if (StringUtils.isEmpty((String)basename) || basenames.contains(basename)) continue;
                basenames.add(basename);
            }
            this.mediaTypesExtendedMsgs = MessagesUtil.chain((String[])basenames.toArray(new String[0]));
            super.setMsgs(this.mediaTypesExtendedMsgs);
        }
        return super.getMsgs();
    }

    protected void populateFromRequest(Object bean) {
        RequestFormUtil requestFormUtil = new RequestFormUtil(this.getRequest());
        HashMap parameters = new HashMap();
        parameters.putAll(this.request.getParameterMap());
        parameters.putAll(requestFormUtil.getDocuments());
        try {
            BeanUtils.populate((Object)bean, parameters);
        }
        catch (Exception e) {
            this.log.error("can't set properties on the handler", (Throwable)e);
        }
    }

    public TemplateMethodModel getGetStatic() {
        return this.getStatic;
    }

    public static class GetStaticMethodModel
    implements TemplateMethodModel {
        public Object exec(List arguments) throws TemplateModelException {
            if (arguments != null && arguments.size() > 0) {
                BeansWrapper wrapper = BeansWrapper.getDefaultInstance();
                TemplateHashModel staticModel = wrapper.getStaticModels();
                return (TemplateHashModel)staticModel.get((String)arguments.get(0));
            }
            return null;
        }
    }
}

