/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.pages;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.core.Path;
import info.magnolia.cms.core.SystemProperty;
import info.magnolia.cms.exchange.ActivationManagerFactory;
import info.magnolia.cms.exchange.ExchangeException;
import info.magnolia.cms.util.AlertUtil;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.commands.CommandsManager;
import info.magnolia.context.MgnlContext;
import info.magnolia.module.admininterface.commands.ActivationCommand;
import it.openutils.mgnlutils.el.MgnlPagingElFunctions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResult;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaTypeConfiguration;
import net.sourceforge.openutils.mgnlmedia.media.lifecycle.MediaModule;
import net.sourceforge.openutils.mgnlmedia.media.pages.MediaBean;
import net.sourceforge.openutils.mgnlmedia.media.pages.MediaBeanBuilder;
import net.sourceforge.openutils.mgnlmedia.media.pages.MessagesTemplatedMVCHandler;
import net.sourceforge.openutils.mgnlmedia.media.pages.SortMode;
import net.sourceforge.openutils.mgnlmedia.media.tags.el.MediaEl;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaFolderViewPage
extends MessagesTemplatedMVCHandler {
    protected String path;
    protected String node;
    protected String dest;
    protected String type;
    protected String bgSelector;
    protected String pagesizeSelector;
    protected String sorting;
    protected boolean selectMedia;
    protected String actMediaHandle;
    protected String mediaType;
    protected Iterator<MediaBean> medias;
    protected Collection<MediaTypeConfiguration> types;
    protected Map<String, Integer> numberOfMedia;
    protected boolean writable;
    protected boolean canPublish;
    protected boolean develop;
    protected String search;
    protected List<MgnlPagingElFunctions.Page> pages;
    protected int page = 1;
    protected AdvancedResult searchResult;

    public MediaFolderViewPage(String name, HttpServletRequest request, HttpServletResponse response) {
        super(name, request, response);
    }

    public void init() {
        super.init();
        if (!StringUtils.isEmpty((String)this.mediaType)) {
            String[] mediaTypes = StringUtils.split((String)this.mediaType, (String)",");
            this.type = mediaTypes[0];
            this.types = new ArrayList<MediaTypeConfiguration>();
            for (String mt : mediaTypes) {
                this.types.add(MediaConfigurationManager.getInstance().getTypes().get(mt));
            }
        } else {
            this.types = MediaConfigurationManager.getInstance().getTypes().values();
        }
        this.bgSelector = null;
        this.pagesizeSelector = null;
        this.sorting = null;
        for (Cookie cookie : this.request.getCookies()) {
            if ("bgselector".equals(cookie.getName())) {
                this.bgSelector = cookie.getValue();
                continue;
            }
            if ("pagesizeselector".equals(cookie.getName())) {
                this.pagesizeSelector = cookie.getValue();
                continue;
            }
            if (!"sorting".equals(cookie.getName())) continue;
            this.sorting = cookie.getValue();
        }
        this.bgSelector = StringUtils.defaultIfEmpty((String)this.bgSelector, (String)"white");
        this.pagesizeSelector = StringUtils.defaultIfEmpty((String)this.pagesizeSelector, (String)"size1");
        try {
            if (this.sorting == null || SortMode.valueOf(this.sorting) == null) {
                this.sorting = this.getDefaultSorting().name();
            }
        }
        catch (IllegalArgumentException e) {
            this.sorting = this.getDefaultSorting().name();
        }
        this.develop = SystemProperty.getBooleanProperty((String)"magnolia.develop");
    }

    protected int countMediaItems(MediaTypeConfiguration type) {
        if (StringUtils.isEmpty((String)this.path) && StringUtils.isBlank((String)this.search)) {
            return 0;
        }
        AdvancedResult typeResult = MediaEl.module().getSearch().search(this.request, type.getName(), this.path, false, this.getDefaultSorting(), 0, 1);
        return typeResult.getTotalSize();
    }

    protected AdvancedResult findMediaItems() {
        AdvancedResult result;
        if (StringUtils.isEmpty((String)this.path)) {
            return null;
        }
        Content folder = ContentUtil.getContent((String)"media", (String)this.path);
        if (folder == null) {
            return null;
        }
        this.writable = folder.isGranted(11L);
        this.canPublish = this.writable && ActivationManagerFactory.getActivationManager().hasAnyActiveSubscriber();
        MediaModule module = MediaEl.module();
        Integer itemsPerPage = module.getFolderViewPageSizes().get(this.pagesizeSelector);
        if (itemsPerPage == null) {
            itemsPerPage = module.getFolderViewItemsPerPage();
        }
        if ((result = module.getSearch().search(this.request, this.type, this.path, false, SortMode.valueOf(this.sorting), itemsPerPage, this.page)).getTotalSize() > 0 && result.getNumberOfPages() < this.page) {
            this.page = 1;
            result = module.getSearch().search(this.request, this.type, this.path, false, SortMode.valueOf(this.sorting), itemsPerPage, this.page);
        }
        return result;
    }

    public String show() {
        this.numberOfMedia = new HashMap<String, Integer>();
        int total = 0;
        for (MediaTypeConfiguration type : this.types) {
            int countMediaItems = this.countMediaItems(type);
            this.numberOfMedia.put(type.getName(), countMediaItems);
            total += countMediaItems;
        }
        this.numberOfMedia.put("", total);
        this.searchResult = this.findMediaItems();
        if (this.searchResult != null) {
            UnmodifiableIterator contentIterator = Iterators.filter((Iterator)this.searchResult.getItems(), Content.class);
            this.medias = Iterators.transform((Iterator)contentIterator, (Function)new MediaBeanBuilder());
            this.pages = MgnlPagingElFunctions.pageList((int)this.searchResult.getNumberOfPages(), (int)10, (String)"page");
        }
        if (this.medias == null) {
            this.medias = Iterators.emptyIterator();
        }
        if (this.pages == null) {
            this.pages = Collections.emptyList();
        }
        return super.show();
    }

    public String delete() {
        HierarchyManager hm = MgnlContext.getInstance().getHierarchyManager("media");
        try {
            hm.delete(this.node);
            hm.save();
        }
        catch (RepositoryException ex) {
            this.log.error("Exception deleting node {} from repository media", (Object)this.node, (Object)ex);
        }
        return this.show();
    }

    public String move() {
        String nodeName = StringUtils.substringAfterLast((String)this.node, (String)"/");
        String destinationNode = this.dest + "/" + nodeName;
        try {
            this.copyMoveNode(this.node, destinationNode, true);
        }
        catch (ExchangeException e) {
            this.log.error("Exception deactivating node", (Throwable)e);
            AlertUtil.setMessage((String)"Problem during deactivation");
        }
        catch (RepositoryException e) {
            this.log.error("Exception moving node", (Throwable)e);
            AlertUtil.setMessage((String)"Problem during moving");
        }
        return this.show();
    }

    public String copy() {
        String nodeName = StringUtils.substringAfterLast((String)this.node, (String)"/");
        String destinationNode = this.dest + "/" + nodeName;
        try {
            this.copyMoveNode(this.node, destinationNode, false);
        }
        catch (ExchangeException e) {
            this.log.error("Exception deactivating node", (Throwable)e);
            AlertUtil.setMessage((String)"Problem during deactivation");
        }
        catch (RepositoryException e) {
            this.log.error("Exception copying node", (Throwable)e);
            AlertUtil.setMessage((String)"Problem during copying");
        }
        return this.show();
    }

    public Content copyMoveNode(String source, String destination, boolean move) throws ExchangeException, RepositoryException {
        Content newContent;
        block8: {
            HierarchyManager hm = MgnlContext.getHierarchyManager((String)"media");
            String goTo = destination;
            if (hm.isExist(destination)) {
                String parentPath = StringUtils.substringBeforeLast((String)destination, (String)"/");
                String label = StringUtils.substringAfterLast((String)destination, (String)"/");
                label = Path.getUniqueLabel((HierarchyManager)hm, (String)parentPath, (String)label);
                goTo = parentPath + "/" + label;
            }
            if (move) {
                if (destination.indexOf(source + "/") == 0) {
                    return null;
                }
                try {
                    hm.moveTo(source, goTo);
                }
                catch (Exception e) {
                    return null;
                }
            } else {
                hm.copyTo(source, goTo);
            }
            newContent = hm.getContent(destination);
            try {
                newContent.updateMetaData();
                newContent.getMetaData().setUnActivated();
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block8;
                this.log.debug("Exception caught: " + e.getMessage(), (Throwable)e);
            }
        }
        newContent.save();
        return newContent;
    }

    public String activate() {
        Command cmd = CommandsManager.getInstance().getCommand("media", "activate");
        ActivationCommand actCmd = (ActivationCommand)cmd;
        StringBuffer sb = new StringBuffer();
        sb.append(MediaConfigurationManager.MEDIA.getSystemName());
        sb.append(",");
        sb.append(ItemType.CONTENTNODE.getSystemName());
        actCmd.setItemTypes(sb.toString());
        info.magnolia.context.Context context = MgnlContext.getInstance();
        context.put((Object)"repository", (Object)"media");
        context.put((Object)"path", (Object)this.node);
        context.put((Object)"recursive", (Object)false);
        try {
            cmd.execute((Context)context);
        }
        catch (Exception e) {
            AlertUtil.setMessage((String)("Activation failed: " + e.getMessage()));
            this.log.error("Exception activating media", (Throwable)e);
        }
        return this.show();
    }

    public String deactivate() {
        Command cmd = CommandsManager.getInstance().getCommand("media", "deactivate");
        info.magnolia.context.Context context = MgnlContext.getInstance();
        context.put((Object)"repository", (Object)"media");
        context.put((Object)"path", (Object)this.node);
        try {
            cmd.execute((Context)context);
        }
        catch (Exception e) {
            AlertUtil.setMessage((String)("Deactivation failed: " + e.getMessage()));
            this.log.error("Exception activating media", (Throwable)e);
        }
        return this.show();
    }

    public String download() {
        Content media;
        HierarchyManager hm = MgnlContext.getHierarchyManager((String)"media");
        try {
            media = hm.getContent(this.path);
        }
        catch (RepositoryException e) {
            this.log.error("Error downloading media " + this.path, (Throwable)e);
            return null;
        }
        MediaTypeConfiguration mtc = MediaConfigurationManager.getInstance().getMediaTypeConfigurationFromMedia(media);
        String url = mtc.getHandler().getUrl(media);
        String filename = mtc.getHandler().getFullFilename(media);
        this.response.addHeader("Content-Disposition", "attachment; filename=" + filename);
        try {
            this.request.getRequestDispatcher(url).forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException e) {
            this.log.error("Error downloading media " + this.path, (Throwable)e);
        }
        catch (IOException e) {
            this.log.error("Error downloading media " + this.path, (Throwable)e);
        }
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public Iterator<MediaBean> getMedias() {
        return this.medias;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Collection<MediaTypeConfiguration> getTypes() {
        return this.types;
    }

    public void setTypes(Collection<MediaTypeConfiguration> types) {
        this.types = types;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getBgSelector() {
        return this.bgSelector;
    }

    public String getPagesizeSelector() {
        return this.pagesizeSelector;
    }

    public String getSorting() {
        return this.sorting;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public void setWritable(boolean writable) {
        this.writable = writable;
    }

    public boolean isCanPublish() {
        return this.canPublish;
    }

    public void setCanPublish(boolean canPublish) {
        this.canPublish = canPublish;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public String getDest() {
        return this.dest;
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public boolean isSelectMedia() {
        return this.selectMedia;
    }

    public void setSelectMedia(boolean selectMedia) {
        this.selectMedia = selectMedia;
    }

    public String getActMediaHandle() {
        return this.actMediaHandle;
    }

    public void setActMediaHandle(String actMediaHandle) {
        this.actMediaHandle = actMediaHandle;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public Map<String, Integer> getNumberOfMedia() {
        return this.numberOfMedia;
    }

    public void setNumberOfMedia(Map<String, Integer> numberOfMedia) {
        this.numberOfMedia = numberOfMedia;
    }

    public boolean isDevelop() {
        return this.develop;
    }

    public void setDevelop(boolean develop) {
        this.develop = develop;
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public List<MgnlPagingElFunctions.Page> getPages() {
        return this.pages;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public AdvancedResult getSearchResult() {
        return this.searchResult;
    }

    public boolean isSingleInstance() {
        return MediaEl.module().isSingleinstance();
    }

    public String getMessage(String key, String param) {
        return this.getMsgs().get(key, (Object[])new String[]{param});
    }

    public String currentQueryString() {
        int p1;
        String s = this.request.getQueryString();
        s = "&" + s;
        while ((p1 = StringUtils.indexOfAny((String)s, (String[])new String[]{"&type=", "&command=", "&page="})) != -1) {
            int p2 = s.indexOf(38, p1 + 1);
            s = s.substring(0, p1) + (p2 != -1 ? s.substring(p2) : "");
        }
        return s.substring(1);
    }

    public String mediatabLink(MediaTypeConfiguration type) {
        String s = this.currentQueryString();
        if (type == null) {
            return '?' + s;
        }
        return '?' + s + (s.length() > 0 ? Character.valueOf('&') : "") + "type=" + type.getName();
    }

    protected SortMode getDefaultSorting() {
        return SortMode.FILENAME_ASC;
    }

    public String getModuleVersion() {
        return MediaEl.module().getVersion();
    }
}

