/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.pages;

import info.magnolia.cms.beans.runtime.Document;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.i18n.Messages;
import info.magnolia.cms.util.AlertUtil;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.context.MgnlContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipFile;
import javax.jcr.RepositoryException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.openutils.mgnlmedia.media.pages.MessagesTemplatedMVCHandler;
import net.sourceforge.openutils.mgnlmedia.media.tags.el.MediaEl;
import net.sourceforge.openutils.mgnlmedia.media.zip.DefaultZipImporter;
import net.sourceforge.openutils.mgnlmedia.media.zip.ZipImporter;
import net.sourceforge.openutils.mgnlmedia.media.zip.ZipImporterException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaBrowserPage
extends MessagesTemplatedMVCHandler {
    private Logger log = LoggerFactory.getLogger(MediaBrowserPage.class);
    private String cacheKiller = String.valueOf(new Date().getTime());
    private String actMedia;
    private boolean selectMedia;
    private String nodeid;
    private String openPath;
    private String actMediaHandle;
    private String mediaType;
    private String parentPath;
    private Document zipFile;
    private String playlistHandle;
    private String playlistSearch;

    public MediaBrowserPage(String name, HttpServletRequest request, HttpServletResponse response) {
        super(name, request, response);
    }

    public void init() {
        super.init();
        if (StringUtils.isNotBlank((String)this.actMedia)) {
            HierarchyManager mgr = MgnlContext.getHierarchyManager((String)"media");
            try {
                Content media = mgr.getContentByUUID(this.actMedia);
                this.openPath = media.getParent().getHandle();
                this.actMediaHandle = media.getHandle();
            }
            catch (RepositoryException ex) {
                this.log.warn("Error retrieving media {}", (Object)this.actMedia);
            }
        }
        if (!StringUtils.isEmpty((String)this.playlistHandle)) {
            Content playlistContent = ContentUtil.getContent((String)"playlists", (String)this.playlistHandle);
            try {
                if (playlistContent.hasContent("search")) {
                    ArrayList<String> params = new ArrayList<String>();
                    for (Content content : playlistContent.getContent("search").getChildren()) {
                        String paramName = NodeDataUtil.getString((Content)content, (String)"name");
                        String paramValue = NodeDataUtil.getString((Content)content, (String)"value");
                        params.add(paramName + "=" + paramValue);
                    }
                    this.playlistSearch = StringUtils.join(params, (char)'&');
                }
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        for (Cookie cookie : this.request.getCookies()) {
            if (!"mediafolderpath".equals(cookie.getName())) continue;
            this.log.debug("Found mediafolderpath cookie with value {}", (Object)cookie.getValue());
            if (StringUtils.isEmpty((String)this.openPath)) {
                try {
                    this.openPath = URLDecoder.decode(cookie.getValue(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
            this.log.debug("openPath={}", (Object)this.openPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String saveZip() {
        InputStream zipStream = null;
        File temp = null;
        try {
            temp = File.createTempFile("zipmedia", ".zip");
            FileOutputStream fos = new FileOutputStream(temp);
            zipStream = this.zipFile.getStream();
            IOUtils.copy((InputStream)zipStream, (OutputStream)fos);
            IOUtils.closeQuietly((OutputStream)fos);
            ZipFile zip = new ZipFile(temp);
            ZipImporter importer = MediaEl.module().getZipimporter();
            if (importer == null) {
                importer = new DefaultZipImporter();
            }
            importer.importFromZip(zip, this.parentPath);
            zip.close();
            AlertUtil.setMessage((String)this.getMsgs().get("media.loadzip.success"));
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            AlertUtil.setMessage((String)this.getMessage("media.loadzip.failure", e.getMessage()));
            IOUtils.closeQuietly((InputStream)zipStream);
            FileUtils.deleteQuietly((File)temp);
        }
        catch (ZipImporterException e2) {
            this.log.error(e2.getMessage(), (Throwable)e2);
            AlertUtil.setMessage((String)this.getMessage("media.loadzip.failure", e2.getMessage()));
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(zipStream);
                    FileUtils.deleteQuietly((File)temp);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)zipStream);
            FileUtils.deleteQuietly((File)temp);
        }
        IOUtils.closeQuietly((InputStream)zipStream);
        FileUtils.deleteQuietly((File)temp);
        this.openPath = this.parentPath;
        return this.show();
    }

    public String getCacheKiller() {
        return this.cacheKiller;
    }

    public void setCacheKiller(String cacheKiller) {
        this.cacheKiller = cacheKiller;
    }

    public String getActMedia() {
        return this.actMedia;
    }

    public void setActMedia(String actMedia) {
        this.actMedia = actMedia;
    }

    public boolean isSelectMedia() {
        return this.selectMedia;
    }

    public void setSelectMedia(boolean selectMedia) {
        this.selectMedia = selectMedia;
    }

    public String getNodeid() {
        return this.nodeid;
    }

    public void setNodeid(String nodeid) {
        this.nodeid = nodeid;
    }

    public String getOpenPath() {
        return this.openPath;
    }

    public void setOpenPath(String openPath) {
        this.openPath = openPath;
    }

    public String getActMediaHandle() {
        return this.actMediaHandle;
    }

    public void setActMediaHandle(String actMediaHandle) {
        this.actMediaHandle = actMediaHandle;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public Document getZipFile() {
        return this.zipFile;
    }

    public void setZipFile(Document file) {
        this.zipFile = file;
    }

    public String getPlaylistHandle() {
        return this.playlistHandle;
    }

    public void setPlaylistHandle(String playlistHandle) {
        this.playlistHandle = playlistHandle;
    }

    public String getPlaylistSearch() {
        return this.playlistSearch;
    }

    public void setPlaylistSearch(String playlistSearch) {
        this.playlistSearch = playlistSearch;
    }

    public Messages getMsgs() {
        return super.getMsgs();
    }

    public String getMessage(String key, String arg) {
        return super.getMsgs().get(key, (Object[])new String[]{arg});
    }

    public String getModuleVersion() {
        return MediaEl.module().getVersion();
    }
}

