/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.pages;

import com.google.common.base.Function;
import info.magnolia.cms.beans.config.URI2RepositoryManager;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.exchange.ActivationManagerFactory;
import info.magnolia.cms.util.NodeDataUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaTypeConfiguration;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaUsedInManager;
import net.sourceforge.openutils.mgnlmedia.media.pages.MediaBean;
import net.sourceforge.openutils.mgnlmedia.media.tags.el.MediaEl;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaBeanBuilder
implements Function<Content, MediaBean> {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public MediaBean apply(Content media) {
        String mediatype = media.getNodeData("type").getString();
        MediaTypeConfiguration mtc = MediaConfigurationManager.getInstance().getTypes().get(mediatype);
        if (mtc == null) {
            this.log.warn("Skipping media {} with invalid media type \"{}\"", (Object)media.getHandle(), (Object)mediatype);
            return null;
        }
        MediaBean mb = new MediaBean();
        mb.setContent(media);
        mb.setMetaData(media.getMetaData());
        mb.setHandle(media.getHandle());
        mb.setName(NodeDataUtil.getString((Content)media, (String)"media_name"));
        mb.setFilename(mtc.getHandler().getFilename(media));
        if (StringUtils.isEmpty((String)mb.getName()) && !StringUtils.isEmpty((String)mb.getFilename())) {
            int p = StringUtils.lastIndexOf((String)mb.getFilename(), (char)'/');
            mb.setName(p != -1 ? mb.getFilename().substring(p + 1) : mb.getFilename());
        }
        mb.setTitle(mtc.getHandler().getTitle(media));
        mb.setThumbnailUrl(mtc.getHandler().getThumbnailUrl(media));
        mb.setPreviewUrl(mtc.getHandler().getPreviewUrl(media));
        mb.setDescription(mtc.getHandler().getDescription(media));
        mb.setDialog(mtc.getDialog());
        mb.setUuid(media.getUUID());
        mb.setType(mediatype);
        mb.setIcon(mtc.getMenuIcon());
        try {
            mb.setWritable(media.getParent().isGranted(11L));
            mb.setCanPublish(!MediaEl.module().isSingleinstance() && mb.isWritable() && ActivationManagerFactory.getActivationManager().hasAnyActiveSubscriber());
            Map<String, List<String>> workspacePaths = MediaUsedInManager.getInstance().getUsedInPaths(media.getUUID());
            mb.getUsedInWebPages().addAll((Collection<String>)workspacePaths.get("website"));
            for (Map.Entry<String, List<String>> entry : workspacePaths.entrySet()) {
                String repository = entry.getKey();
                for (String handle : entry.getValue()) {
                    String uri = URI2RepositoryManager.getInstance().getURI(repository, handle);
                    mb.getUsedInUris().add(uri);
                }
            }
        }
        catch (RepositoryException ex) {
            this.log.error("Exception caught", (Throwable)ex);
        }
        mb.setMediaInfo(mtc.getHandler().getMediaInfo(media));
        mb.setExternal(mtc.getHandler().isExternal(media));
        return mb;
    }
}

