/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.pages;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import info.magnolia.cms.core.Content;
import info.magnolia.context.MgnlContext;
import info.magnolia.freemarker.FreemarkerUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResult;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResultItem;
import net.sourceforge.openutils.mgnlmedia.media.advancedsearch.configuration.SearchMediaQueryConfiguration;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaTypeConfiguration;
import net.sourceforge.openutils.mgnlmedia.media.pages.MediaFolderViewPage;
import net.sourceforge.openutils.mgnlmedia.media.pages.SortMode;
import net.sourceforge.openutils.mgnlmedia.media.tags.el.MediaEl;
import net.sourceforge.openutils.mgnlmedia.playlist.pages.PlaylistView;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaAdvancedSearchPage
extends MediaFolderViewPage {
    private static final String VIEW_RESULTS_XML = "-xml";
    private String format;
    private String selectTab;

    public MediaAdvancedSearchPage(String name, HttpServletRequest request, HttpServletResponse response) {
        super(name, request, response);
    }

    protected String getTemplateName(String viewName) {
        if ("show".equals(viewName)) {
            return FreemarkerUtil.createTemplateName(MediaFolderViewPage.class, (String)"html");
        }
        if (VIEW_RESULTS_XML.equals(viewName)) {
            return FreemarkerUtil.createTemplateName(PlaylistView.class, (String)"-xspf", (String)"html");
        }
        return super.getTemplateName(viewName);
    }

    @Override
    protected int countMediaItems(MediaTypeConfiguration type) {
        if ("xml".equals(this.format)) {
            return 0;
        }
        return MediaEl.module().getSearch().search(this.request, type.getName(), "/", true, SortMode.SCORE, 0, 1).getTotalSize();
    }

    @Override
    protected AdvancedResult findMediaItems() {
        SearchMediaQueryConfiguration searchConfig = MediaEl.module().getSearch();
        if ("xml".equals(this.format)) {
            return searchConfig.search(this.request, null, null, true, SortMode.SCORE, searchConfig.getXmlItemsPerPage(), this.page);
        }
        return searchConfig.search(this.request, this.type, "/", true, SortMode.valueOf(this.sorting), MediaEl.module().getFolderViewItemsPerPage(), this.page);
    }

    @Override
    public String show() {
        super.show();
        this.selectTab = StringUtils.trimToEmpty((String)this.selectTab);
        if (StringUtils.isNotBlank((String)this.selectTab)) {
            this.setType(this.selectTab);
        }
        if (!StringUtils.isNotBlank((String)this.selectTab)) {
            this.selectTab = this.getType();
        }
        if ("xml".equals(this.format)) {
            this.response.setContentType("text/xml");
            return VIEW_RESULTS_XML;
        }
        return "show";
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getSelectTab() {
        return this.selectTab;
    }

    public void setSelectTab(String selectTab) {
        this.selectTab = selectTab;
    }

    @Override
    protected SortMode getDefaultSorting() {
        return SortMode.SCORE;
    }

    public String playlistTitle() {
        return null;
    }

    public String playlistLocation() {
        return "/media/search?" + this.currentQueryString();
    }

    public Map<String, Object> playlistMetas() {
        LinkedHashMap<String, Object> metas = new LinkedHashMap<String, Object>();
        metas.put("page", this.searchResult.getPage());
        metas.put("itemsperpage", this.searchResult.getItemsPerPage());
        metas.put("totalitems", this.searchResult.getTotalSize());
        return metas;
    }

    public Iterator<Content> getMediaContentList() {
        return Iterators.transform((Iterator)this.searchResult.getItems(), (Function)new Function<AdvancedResultItem, Content>(){

            public Content apply(AdvancedResultItem from) {
                try {
                    return MgnlContext.getHierarchyManager((String)"media").getContentByUUID(from.getUUID());
                }
                catch (RepositoryException e) {
                    return null;
                }
            }
        });
    }

    public String saveAsPlaylist() {
        return this.show();
    }
}

