/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.lifecycle;

import info.magnolia.cms.beans.config.ObservedManager;
import info.magnolia.module.ModuleLifecycle;
import info.magnolia.module.ModuleLifecycleContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.openutils.mgnlmedia.media.advancedsearch.configuration.SearchMediaQueryConfiguration;
import net.sourceforge.openutils.mgnlmedia.media.configuration.ImageProcessorsManager;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaTypeConfiguration;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaUsedInManager;
import net.sourceforge.openutils.mgnlmedia.media.zip.ZipImporter;
import net.sourceforge.openutils.mgnlmedia.playlist.pages.PlaylistLink;
import net.sourceforge.openutils.mgnlmedia.playlist.pages.PlaylistTrackExtensionContributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaModule
implements ModuleLifecycle {
    public static final String NAME = "media";
    public static final String REPO = "media";
    private Logger log = LoggerFactory.getLogger(MediaModule.class);
    private boolean singleinstance;
    private String player = "player.swf";
    private String version;
    private SearchMediaQueryConfiguration search;
    private int folderViewItemsPerPage;
    private Map<String, Integer> folderViewPageSizes = new HashMap<String, Integer>();
    private ZipImporter zipimporter;
    private List playlistTrackExtensionContributors = new ArrayList();
    private List playlistLinks = new ArrayList();

    public void start(ModuleLifecycleContext ctx) {
        this.log.info("Starting module media");
        ctx.registerModuleObservingComponent("mediatypes", (ObservedManager)MediaConfigurationManager.getInstance());
        ctx.registerModuleObservingComponent("processors", (ObservedManager)ImageProcessorsManager.getInstance());
        ctx.registerModuleObservingComponent("mediausedin", (ObservedManager)MediaUsedInManager.getInstance());
        this.version = ctx.getCurrentModuleDefinition().getVersion().toString();
    }

    public void stop(ModuleLifecycleContext ctx) {
        this.log.info("Stopping module media");
        Collection<MediaTypeConfiguration> mtcs = MediaConfigurationManager.getInstance().getTypes().values();
        if (mtcs != null) {
            for (MediaTypeConfiguration mtc : mtcs) {
                if (mtc.getHandler() == null) continue;
                mtc.getHandler().stop();
            }
        }
    }

    @Deprecated
    public boolean isAutoactivate() {
        return this.singleinstance;
    }

    @Deprecated
    public void setAutoactivate(boolean autoactivate) {
        this.singleinstance = autoactivate;
    }

    public boolean isSingleinstance() {
        return this.singleinstance;
    }

    public void setSingleinstance(boolean singleinstance) {
        this.singleinstance = singleinstance;
    }

    public String getPlayer() {
        return this.player;
    }

    public void setPlayer(String player) {
        this.player = player;
    }

    public String getVersion() {
        return this.version;
    }

    public SearchMediaQueryConfiguration getSearch() {
        return this.search;
    }

    public void setSearch(SearchMediaQueryConfiguration search) {
        this.search = search;
    }

    public int getFolderViewItemsPerPage() {
        return this.folderViewItemsPerPage;
    }

    public void setFolderViewItemsPerPage(int folderViewItemsPerPage) {
        this.folderViewItemsPerPage = folderViewItemsPerPage;
    }

    public Map<String, Integer> getFolderViewPageSizes() {
        return this.folderViewPageSizes;
    }

    public void addFolderViewPageSizes(String sizeKey, Long value) {
        this.folderViewPageSizes.put(sizeKey, value.intValue());
    }

    public ZipImporter getZipimporter() {
        return this.zipimporter;
    }

    public void setZipimporter(ZipImporter zipimporter) {
        this.zipimporter = zipimporter;
    }

    public List getPlaylistTrackExtensionContributors() {
        return this.playlistTrackExtensionContributors;
    }

    public void setPlaylistTrackExtensionContributors(List playlistTrackExtensionContributors) {
        this.playlistTrackExtensionContributors = playlistTrackExtensionContributors;
    }

    public void addPlaylistTrackExtensionContributor(PlaylistTrackExtensionContributor contributor) {
        this.playlistTrackExtensionContributors.add(contributor);
    }

    public List getPlaylistLinks() {
        return this.playlistLinks;
    }

    public void setPlaylistLinks(List playlistLinks) {
        this.playlistLinks = playlistLinks;
    }

    public void addPlaylistLink(PlaylistLink playlistLink) {
        this.playlistLinks.add(playlistLink);
    }
}

