/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.crop;

import java.awt.image.BufferedImage;
import java.util.Map;
import net.sourceforge.openutils.mgnlmedia.media.processors.ResizeCropCenteredImageResolutionProcessor;
import net.sourceforge.openutils.mgnlmedia.media.utils.ImageUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PzcImageProcessor
extends ResizeCropCenteredImageResolutionProcessor {
    @Override
    public BufferedImage getImageForResolution(BufferedImage original, int x, int y, Map<String, String> parameters) {
        int oWidth = original.getWidth();
        int oHeight = original.getHeight();
        if (x == oWidth && y == oHeight) {
            return original;
        }
        String pzcParametersString = parameters.get("pzc");
        if (StringUtils.isBlank((String)pzcParametersString)) {
            return super.getImageForResolution(original, x, y, parameters);
        }
        String[] params = StringUtils.split((String)pzcParametersString, (char)'|');
        float zoom = Float.parseFloat(params[0]) / 100.0f;
        float panX = Float.parseFloat(params[1]);
        float panY = Float.parseFloat(params[2]);
        float factor = 1.0f;
        if (params.length > 3) {
            factor = Float.parseFloat(params[3]);
        }
        float oX = (float)oWidth * zoom * factor;
        float oY = oX * (float)oHeight / (float)oWidth;
        BufferedImage filled = ImageUtils.resizeImage(original, (int)oX, (int)oY);
        return ImageUtils.cropImage(filled, (int)(panX * factor), (int)(panY * factor), x, y);
    }
}

