/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.configuration;

import info.magnolia.cms.beans.config.ObservedManager;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.util.FactoryUtil;
import info.magnolia.content2bean.Content2BeanException;
import info.magnolia.content2bean.Content2BeanUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResult;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResultItem;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.Criteria;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.JCRCriteriaFactory;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Criterion;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Order;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Restrictions;
import net.sourceforge.openutils.mgnlmedia.media.configuration.UsedInWorkspace;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaUsedInManager
extends ObservedManager {
    private static Logger log = LoggerFactory.getLogger(MediaUsedInManager.class);
    private Map<String, UsedInWorkspace> usedInWorkspaceMap = new HashMap<String, UsedInWorkspace>();

    public static MediaUsedInManager getInstance() {
        return (MediaUsedInManager)((Object)FactoryUtil.getSingleton(MediaUsedInManager.class));
    }

    protected void onClear() {
        this.usedInWorkspaceMap.clear();
    }

    protected void onRegister(Content node) {
        Collection uiwNodes = node.getChildren(ItemType.CONTENTNODE);
        for (Content uiwNode : uiwNodes) {
            try {
                UsedInWorkspace uiw = (UsedInWorkspace)Content2BeanUtil.toBean((Content)uiwNode, UsedInWorkspace.class);
                if (StringUtils.isEmpty((String)uiw.getWorkspaceName())) {
                    uiw.setWorkspaceName(uiwNode.getName());
                }
                if (StringUtils.isEmpty((String)uiw.getNodeType())) {
                    uiw.setNodeType(ItemType.CONTENT.getSystemName());
                }
                this.usedInWorkspaceMap.put(uiw.getWorkspaceName(), uiw);
            }
            catch (Content2BeanException e) {
                log.error("Error getting media used-in for {}", (Object)uiwNode.getHandle(), (Object)e);
            }
        }
    }

    public Map<String, List<String>> getUsedInPaths(String mediaUUID) throws InvalidQueryException, RepositoryException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(this.usedInWorkspaceMap.size());
        for (String workspaceName : this.usedInWorkspaceMap.keySet()) {
            map.put(workspaceName, this.getUsedInWorkspacePaths(mediaUUID, workspaceName));
        }
        return map;
    }

    public List<String> getUsedInWorkspacePaths(String mediaUUID, String workspaceName) throws InvalidQueryException, RepositoryException {
        UsedInWorkspace uiw = this.usedInWorkspaceMap.get(workspaceName);
        if (uiw == null) {
            if ("website".equals(workspaceName) && this.usedInWorkspaceMap.isEmpty()) {
                uiw = UsedInWorkspace.DEFAULT_WEBSITE;
            } else {
                return Collections.emptyList();
            }
        }
        List<Content> nodes = MediaUsedInManager.getUsedInWorkspaceNodes(mediaUUID, uiw);
        ArrayList<String> paths = new ArrayList<String>(nodes.size());
        for (Content node : nodes) {
            paths.add(node.getHandle());
        }
        return paths;
    }

    private static List<Content> getUsedInWorkspaceNodes(String mediaUUID, UsedInWorkspace uiw) throws InvalidQueryException, RepositoryException {
        ArrayList<Content> nodes = new ArrayList<Content>();
        HashSet<String> handles = new HashSet<String>();
        String basepath = "/jcr:root" + StringUtils.defaultString((String)uiw.getBasePath());
        if (!StringUtils.endsWith((String)basepath, (String)"/")) {
            basepath = basepath + "/";
        }
        basepath = basepath + "/*";
        Criteria criteria = JCRCriteriaFactory.createCriteria().setWorkspace(uiw.getWorkspaceName()).setBasePath(basepath).add((Criterion)Restrictions.contains((String)uiw.getPropertyName(), (Object)mediaUUID)).add(Restrictions.not((Criterion)Restrictions.eq((String)"@jcr:primaryType", (Object)"nt:frozenNode"))).addOrder(Order.desc((String)"@jcr:score"));
        AdvancedResult result = criteria.execute();
        log.debug("{} > {}", (Object)criteria.toXpathExpression(), (Object)result.getTotalSize());
        for (AdvancedResultItem item : result.getItems()) {
            while (!item.getNodeTypeName().equals(uiw.getNodeType()) && item.getLevel() > 1) {
                item = item.getParent();
            }
            if (!item.getNodeTypeName().equals(uiw.getNodeType()) || handles.contains(item.getHandle())) continue;
            nodes.add((Content)item);
            handles.add(item.getHandle());
        }
        return nodes;
    }
}

