/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.configuration;

import info.magnolia.cms.beans.config.ObservedManager;
import info.magnolia.cms.beans.config.URI2RepositoryManager;
import info.magnolia.cms.beans.config.URI2RepositoryMapping;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.core.search.Query;
import info.magnolia.cms.core.search.QueryManager;
import info.magnolia.cms.core.search.QueryResult;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.cms.util.FactoryUtil;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.content2bean.Content2BeanUtil;
import info.magnolia.context.MgnlContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaTypeConfiguration;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaUsedInManager;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaConfigurationManager
extends ObservedManager {
    private static final String MGNL_MEDIA_TYPE = "mgnl:media";
    private static final String MGNL_RESOLUTION_TYPE = "mgnl:resolutions";
    public static final ItemType FOLDER = ItemType.CONTENT;
    public static final ItemType MEDIA = new ItemType("mgnl:media");
    public static final ItemType RESOLUTIONS = new ItemType("mgnl:resolutions");
    private Logger log = LoggerFactory.getLogger(MediaConfigurationManager.class);
    private Map<String, MediaTypeConfiguration> types = new LinkedHashMap<String, MediaTypeConfiguration>();

    protected void onClear() {
        this.types.clear();
    }

    protected void onRegister(Content node) {
        for (Content typeNode : ContentUtil.getAllChildren((Content)node)) {
            if (!NodeDataUtil.getBoolean((Content)typeNode, (String)"enabled", (boolean)true)) continue;
            try {
                MediaTypeConfiguration conf = (MediaTypeConfiguration)Content2BeanUtil.toBean((Content)typeNode, (boolean)true, MediaTypeConfiguration.class);
                if (conf.getHandler() == null) {
                    this.log.error("Missing handler for media type {}", (Object)typeNode.getName());
                    continue;
                }
                conf.getHandler().init(typeNode);
                this.types.put(typeNode.getName(), conf);
            }
            catch (Throwable e) {
                this.log.error("Error getting media type configuration for {}", (Object)typeNode.getHandle(), (Object)e);
            }
        }
    }

    public static MediaConfigurationManager getInstance() {
        return (MediaConfigurationManager)((Object)FactoryUtil.getSingleton(MediaConfigurationManager.class));
    }

    public static MediaTypeConfiguration getMediaHandlerFromExtension(String extension) {
        if (extension == null) {
            return null;
        }
        String lowerCasedExtension = extension.toLowerCase();
        for (Map.Entry<String, MediaTypeConfiguration> entry : MediaConfigurationManager.getInstance().getTypes().entrySet()) {
            MediaTypeConfiguration value = entry.getValue();
            List<String> extensionsList = value.getExtensionsList();
            if (extensionsList == null || !extensionsList.contains(lowerCasedExtension)) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<String, MediaTypeConfiguration> getTypes() {
        return this.types;
    }

    public List<String> getUsedInWebPages(String uuid) throws InvalidQueryException, RepositoryException {
        return MediaUsedInManager.getInstance().getUsedInWorkspacePaths(uuid, "website");
    }

    @Deprecated
    public Collection<Content> search(String text, String type) throws RepositoryException {
        return this.find(null, type, text, true);
    }

    @Deprecated
    public Collection<Content> find(String path, String type, String search, boolean recursive) throws RepositoryException {
        QueryManager qm = MgnlContext.getQueryManager((String)"media");
        StringBuffer sbQuery = new StringBuffer("/jcr:root/");
        if (StringUtils.isNotEmpty((String)(path = StringUtils.removeEnd((String)StringUtils.removeStart((String)StringUtils.trimToEmpty((String)path), (String)"/"), (String)"/")))) {
            sbQuery.append(ISO9075.encodePath((String)path)).append('/');
        }
        if (recursive) {
            sbQuery.append('/');
        }
        sbQuery.append("element(*," + MEDIA.getSystemName() + ")");
        ArrayList<String> clauses = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)search)) {
            clauses.add("jcr:contains(.,'" + StringUtils.replace((String)search, (String)"'", (String)"''") + "')");
        }
        if (StringUtils.isNotBlank((String)type)) {
            clauses.add("@type='" + type + "'");
        }
        if (!clauses.isEmpty()) {
            sbQuery.append('[').append(StringUtils.join(clauses, (String)" and ")).append(']');
        }
        if (StringUtils.isNotBlank((String)search)) {
            sbQuery.append(" order by @jcr:score descending");
        }
        Query q = qm.createQuery(new String(sbQuery), "xpath");
        QueryResult qr = q.execute();
        return qr.getContent(MGNL_MEDIA_TYPE);
    }

    public MediaTypeConfiguration getMediaTypeConfigurationFromMedia(Content media) {
        try {
            if (!media.getItemType().equals((Object)MEDIA)) {
                return null;
            }
        }
        catch (RepositoryException e) {
            this.log.error("Error getting item type on node {} module media", (Object)media.getHandle(), (Object)e);
            return null;
        }
        return this.types.get(NodeDataUtil.getString((Content)media, (String)"type"));
    }

    public String getURIMappingPrefix() {
        Collection mappings = URI2RepositoryManager.getInstance().getMappings();
        for (URI2RepositoryMapping mapping : mappings) {
            if (!mapping.getRepository().equals("media")) continue;
            return mapping.getURIPrefix();
        }
        return "";
    }
}

