/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.commands;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.exchange.ExchangeException;
import info.magnolia.cms.i18n.MessagesManager;
import info.magnolia.cms.util.AlertUtil;
import info.magnolia.cms.util.Rule;
import info.magnolia.context.Context;
import info.magnolia.module.admininterface.commands.ActivationCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaActivationCommand
extends ActivationCommand {
    private Logger log = LoggerFactory.getLogger(MediaActivationCommand.class);

    public boolean execute(Context ctx) {
        block9: {
            try {
                Content thisState = this.getNode(ctx);
                String parentPath = StringUtils.substringBeforeLast((String)thisState.getHandle(), (String)"/");
                if (StringUtils.isEmpty((String)parentPath)) {
                    parentPath = "/";
                }
                if (super.isRecursive()) {
                    List versionMap = this.getVersionMap();
                    if (versionMap == null) {
                        this.activateRecursive(parentPath, thisState, ctx);
                    } else {
                        this.activateRecursive(ctx, versionMap);
                    }
                    break block9;
                }
                if (StringUtils.isNotEmpty((String)this.getVersion())) {
                    try {
                        thisState = thisState.getVersionedContent(this.getVersion());
                    }
                    catch (RepositoryException re) {
                        this.log.error("Failed to get version " + this.getVersion() + " for " + thisState.getHandle(), (Throwable)re);
                    }
                }
                this.activateRecursiveOneLevel(parentPath, thisState);
            }
            catch (Exception e) {
                this.log.error("can't activate", (Throwable)e);
                AlertUtil.setException((String)MessagesManager.get((String)"tree.error.activate"), (Exception)e, (Context)ctx);
                return false;
            }
        }
        this.log.info("exec successfully.");
        return true;
    }

    public void activateRecursiveOneLevel(String parentPath, Content node) throws RepositoryException, ExchangeException {
        this.activateSingleNode(parentPath, node);
        Iterator children = node.getChildren(new Content.ContentFilter(){

            public boolean accept(Content content) {
                try {
                    return !MediaActivationCommand.this.getRule().isAllowed(content.getNodeTypeName()) && !ItemType.CONTENT.getSystemName().equals(content.getNodeTypeName()) && !MediaConfigurationManager.RESOLUTIONS.getSystemName().equals(content.getNodeTypeName());
                }
                catch (RepositoryException e) {
                    MediaActivationCommand.this.log.error("can't get nodetype", (Throwable)e);
                    return false;
                }
            }
        }).iterator();
        while (children.hasNext()) {
            this.activateRecursiveOneLevel(node.getHandle(), (Content)children.next());
        }
    }

    protected void activateSingleNode(String parentPath, Content node) throws RepositoryException, ExchangeException {
        if (MediaConfigurationManager.MEDIA.equals((Object)node.getItemType()) && node.getMetaData().getIsActivated()) {
            this.log.warn("Activating already active media {}, will deactivate existing node in order to remove stale resolutions", (Object)node.getHandle());
            this.getSyndicator().deactivate(node);
        }
        this.checkFolderActivation(node);
        this.getSyndicator().activate(parentPath, node, this.getOrderingInfo(node));
    }

    private void checkFolderActivation(Content node) throws ExchangeException {
        try {
            ArrayList<Content> foldersInPath = new ArrayList<Content>(3);
            Content parent = node.getParent();
            while (parent.getLevel() != 0 && !parent.getMetaData().getIsActivated()) {
                foldersInPath.add(parent);
                parent = parent.getParent();
            }
            if (!foldersInPath.isEmpty()) {
                Collections.reverse(foldersInPath);
                for (Content folder : foldersInPath) {
                    this.log.info("Activating parent folder {}", (Object)folder.getHandle());
                    this.setRule(new Rule(new String[]{"mgnl:metaData", "mgnl:resource"}));
                    this.getSyndicator().activate(folder.getParent().getHandle(), folder, this.getOrderingInfo(folder));
                }
            }
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void activateRecursive(String parentPath, Content node, Context ctx) throws ExchangeException, RepositoryException {
        this.getSyndicator().activate(parentPath, node, this.getOrderingInfo(node));
        Iterator children = node.getChildren(new Content.ContentFilter(){

            public boolean accept(Content content) {
                try {
                    return !MediaActivationCommand.this.getRule().isAllowed(content.getNodeTypeName()) && !MediaConfigurationManager.RESOLUTIONS.getSystemName().equals(content.getNodeTypeName());
                }
                catch (RepositoryException e) {
                    MediaActivationCommand.this.log.error("can't get nodetype", (Throwable)e);
                    return false;
                }
            }
        }).iterator();
        while (children.hasNext()) {
            this.activateRecursive(node.getHandle(), (Content)children.next(), ctx);
        }
    }
}

