/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.advancedsearch.configuration;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResult;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.Criteria;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.JCRCriteriaFactory;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Criterion;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Order;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Restrictions;
import net.sourceforge.openutils.mgnlmedia.media.advancedsearch.SearchFilter;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.pages.SortMode;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchMediaQueryConfiguration {
    private Logger log = LoggerFactory.getLogger(SearchMediaQueryConfiguration.class);
    private Map<String, SearchFilter> filters = new LinkedHashMap<String, SearchFilter>();
    private String defaultBasePath;
    private int xmlItemsPerPage;

    public Map<String, SearchFilter> getFilters() {
        return this.filters;
    }

    public void addFilter(String name, SearchFilter filter) {
        this.filters.put(name, filter);
    }

    public void setDefaultBasePath(String defaultBasePath) {
        this.defaultBasePath = defaultBasePath;
    }

    public int getXmlItemsPerPage() {
        return this.xmlItemsPerPage;
    }

    public void setXmlItemsPerPage(int xmlItemsPerPage) {
        this.xmlItemsPerPage = xmlItemsPerPage;
    }

    public AdvancedResult search(HttpServletRequest request, String mediaType, String path, boolean descendants, SortMode sorting, int itemsPerPage, int pageNumberStartingFromOne) {
        Criteria c = JCRCriteriaFactory.createCriteria().setWorkspace("media").add((Criterion)Restrictions.eq((String)"@jcr:primaryType", (Object)MediaConfigurationManager.MEDIA.getSystemName()));
        if (!StringUtils.isEmpty((String)mediaType)) {
            c.add((Criterion)Restrictions.eq((String)"@type", (Object)mediaType));
        }
        path = StringUtils.defaultString((String)path, (String)this.defaultBasePath);
        for (String key : this.filters.keySet()) {
            if ("type".equals(key) && !StringUtils.isEmpty((String)mediaType)) continue;
            SearchFilter filter = this.filters.get(key);
            path = StringUtils.defaultIfEmpty((String)filter.getBasePath(key, request), (String)path);
            for (Criterion criterion : filter.getCriterionList(key, request)) {
                c.add(criterion);
            }
            SortMode s = filter.getSorting(key, request);
            if (s == null) continue;
            sorting = s;
        }
        String searchPath = StringUtils.removeEnd((String)path, (String)"/") + "/" + (descendants ? "/" : "") + "*";
        c.setBasePath("/jcr:root/" + StringUtils.removeStart((String)searchPath, (String)"/"));
        if (sorting == SortMode.SCORE) {
            c.addOrder(Order.desc((String)"@jcr:score"));
        } else if (sorting == SortMode.CREATIONDATE_ASC) {
            c.addOrder(Order.asc((String)"@jcr:created"));
        } else if (sorting == SortMode.CREATIONDATE_DESC) {
            c.addOrder(Order.desc((String)"@jcr:created"));
        } else if (sorting == SortMode.FILENAME_ASC) {
            c.addOrder(Order.asc((String)"@media_name"));
        } else if (sorting == SortMode.FILENAME_DESC) {
            c.addOrder(Order.desc((String)"@media_name"));
        }
        if (itemsPerPage > 0) {
            c.setPaging(itemsPerPage, pageNumberStartingFromOne);
        }
        AdvancedResult result = c.execute();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Executing {} -> {} results", (Object)c.toXpathExpression(), (Object)result.getTotalSize());
        }
        return result;
    }
}

