/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.advancedsearch;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Criterion;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Restrictions;
import net.sourceforge.openutils.mgnlmedia.media.advancedsearch.SearchFilterAbstract;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchFilterStatusModified
extends SearchFilterAbstract {
    private static final String META_DATA_MGNL_ACTIVATED = "MetaData/@mgnl:activated";
    private static final String META_DATA_MGNL_LAST_ACTION = "MetaData/@mgnl:lastaction";
    private static final String META_DATA_MGNL_LAST_MODIFIED = "MetaData/@mgnl:lastmodified";

    @Override
    public List<Criterion> getCriterionList(String parameter, HttpServletRequest request) {
        String[] values = (String[])request.getParameterMap().get(parameter);
        ArrayList<Criterion> criterionList = new ArrayList<Criterion>();
        if (values != null && values.length > 0 && StringUtils.isNotBlank((String)values[0])) {
            criterionList.add((Criterion)Restrictions.eq((String)META_DATA_MGNL_ACTIVATED, (Object)"true"));
            Calendar date = this.getDate(values[0]);
            criterionList.add((Criterion)Restrictions.le((String)META_DATA_MGNL_LAST_ACTION, (Object)date));
            criterionList.add((Criterion)Restrictions.gt((String)META_DATA_MGNL_LAST_MODIFIED, (Object)date));
        }
        return criterionList;
    }

    private Calendar getDate(String date) {
        Calendar cal = Calendar.getInstance();
        Pattern datePattern = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})");
        Matcher dateMatcher = datePattern.matcher(date);
        try {
            if (dateMatcher.find()) {
                cal.set(Integer.parseInt(dateMatcher.group(1)), Integer.parseInt(dateMatcher.group(2)) - 1, Integer.parseInt(dateMatcher.group(3)));
            }
        }
        catch (Exception e) {
            this.log.error("Invalid date: {}", (Object)date);
        }
        return cal;
    }
}

