/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.advancedsearch;

import info.magnolia.cms.core.Content;
import info.magnolia.context.MgnlContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.RepositoryException;
import net.sourceforge.openutils.mgnlmedia.media.advancedsearch.Option;
import net.sourceforge.openutils.mgnlmedia.media.advancedsearch.SearchFilterAbstract;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchFilterOptionProvider
extends SearchFilterAbstract {
    private List<Option> options = new ArrayList<Option>();
    private String reference;
    private boolean addempty;

    public List<Option> getOptions() {
        return this.options;
    }

    public void addOptions(Option option) {
        this.options.add(option);
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
        this.getOptionsFormReference(reference);
    }

    public boolean isAddempty() {
        return this.addempty;
    }

    public void setAddempty(boolean addempty) {
        this.addempty = addempty;
    }

    private void getOptionsFormReference(String reference) {
        if (StringUtils.isNotBlank((String)reference)) {
            try {
                Collection referenceOptions = MgnlContext.getHierarchyManager((String)"config").getContent(reference).getChildren();
                Option opt = new Option();
                if (this.addempty) {
                    opt.setValue("");
                    opt.setLabel("---");
                    this.addOptions(opt);
                }
                for (Content content : referenceOptions) {
                    opt = new Option();
                    opt.setLabel(content.getNodeData("label").getString());
                    opt.setValue(content.getNodeData("value").getString());
                    this.addOptions(opt);
                }
            }
            catch (RepositoryException e) {
                this.log.error("Errore reference node on SearchFilterOptionProvider, {}", (Throwable)e);
            }
        }
    }
}

