/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.advancedsearch;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Criterion;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Restrictions;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.SimpleExpression;
import net.sourceforge.openutils.mgnlmedia.media.advancedsearch.SearchFilterAbstract;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchFilterBeetweenCreationDate
extends SearchFilterAbstract {
    private static final String META_DATA_MGNL_CREATIONDATE = "MetaData/@mgnl:creationdate";
    private Calendar from;
    private Calendar to;

    @Override
    public List<Criterion> getCriterionList(String parameter, HttpServletRequest request) {
        String[] values = (String[])request.getParameterMap().get(parameter);
        ArrayList<Criterion> criterionList = new ArrayList<Criterion>();
        if (values != null && values.length > 0 && StringUtils.isNotBlank((String)values[0])) {
            this.from = this.getDate(values[0]);
            SimpleExpression c = Restrictions.gt((String)META_DATA_MGNL_CREATIONDATE, (Object)this.from);
            if (MapUtils.isNotEmpty(this.getSubfilters())) {
                String key = this.getSubfilters().keySet().iterator().next();
                values = (String[])request.getParameterMap().get(key);
                if (StringUtils.isNotBlank((String)values[0])) {
                    this.to = this.getDate(values[0]);
                    c = Restrictions.between((String)META_DATA_MGNL_CREATIONDATE, (Object)this.from, (Object)this.to);
                }
            }
            criterionList.add((Criterion)c);
        }
        return criterionList;
    }

    private Calendar getDate(String date) {
        Calendar cal = Calendar.getInstance();
        Pattern datePattern = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})");
        Matcher dateMatcher = datePattern.matcher(date);
        try {
            if (dateMatcher.find()) {
                cal.set(Integer.parseInt(dateMatcher.group(1)), Integer.parseInt(dateMatcher.group(2)) - 1, Integer.parseInt(dateMatcher.group(3)));
            }
        }
        catch (Exception e) {
            this.log.error("Invalid date: {}", (Object)date);
        }
        return cal;
    }

    public Calendar getFrom() {
        return this.from;
    }

    public void setFrom(Calendar from) {
        this.from = from;
    }

    public Calendar getTo() {
        return this.to;
    }

    public void setTo(Calendar to) {
        this.to = to;
    }
}

