/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.playlist.tree;

import info.magnolia.cms.beans.config.ServerConfiguration;
import info.magnolia.cms.exchange.ActivationManagerFactory;
import info.magnolia.cms.gui.control.ContextMenuItem;
import info.magnolia.cms.gui.control.FunctionBarItem;
import info.magnolia.cms.gui.control.Tree;
import info.magnolia.cms.gui.control.TreeColumn;
import info.magnolia.cms.i18n.Messages;
import info.magnolia.module.admininterface.AbstractTreeConfiguration;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.tags.el.MediaEl;
import net.sourceforge.openutils.mgnlmedia.playlist.PlaylistConstants;

public class PlaylistsTreeConfiguration
extends AbstractTreeConfiguration {
    public void prepareContextMenu(Tree tree, boolean browseMode, HttpServletRequest request) {
        Messages msgs = this.getMessages();
        ContextMenuItem menuNewFolder = new ContextMenuItem("newFolder");
        menuNewFolder.setLabel(msgs.get("tree.config.menu.newFolder"));
        menuNewFolder.setIcon(request.getContextPath() + "/.resources/media/icons/ico16-folder.png");
        menuNewFolder.setOnclick(tree.getJavascriptTree() + ".createNode('" + MediaConfigurationManager.FOLDER.getSystemName() + "');");
        menuNewFolder.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotItemType(" + tree.getJavascriptTree() + ", '" + PlaylistConstants.PLAYLIST.getSystemName() + "')");
        menuNewFolder.addJavascriptCondition("new mgnlTreeMenuItemConditionPermissionWrite(" + tree.getJavascriptTree() + ")");
        ContextMenuItem menuNewPlaylist = new ContextMenuItem("newPlaylist");
        menuNewPlaylist.setLabel(msgs.get("tree.playlists.new"));
        menuNewPlaylist.setIcon(request.getContextPath() + "/.resources/media/icons/ico16-playlist.png");
        menuNewPlaylist.setOnclick(tree.getJavascriptTree() + ".createNode('" + PlaylistConstants.PLAYLIST.getSystemName() + "');");
        menuNewPlaylist.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedItemType(" + tree.getJavascriptTree() + ", '" + PlaylistConstants.FOLDER.getSystemName() + "')");
        menuNewPlaylist.addJavascriptCondition("new mgnlTreeMenuItemConditionPermissionWrite(" + tree.getJavascriptTree() + ")");
        ContextMenuItem menuDelete = new ContextMenuItem("delete");
        menuDelete.setLabel(msgs.get("tree.config.menu.delete"));
        menuDelete.setIcon(request.getContextPath() + "/.resources/icons/16/delete2.gif");
        menuDelete.setOnclick(tree.getJavascriptTree() + ".deleteNode();");
        menuDelete.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotRoot(" + tree.getJavascriptTree() + ")");
        menuDelete.addJavascriptCondition("new mgnlTreeMenuItemConditionPermissionWrite(" + tree.getJavascriptTree() + ")");
        ContextMenuItem menuCopy = new ContextMenuItem("copy");
        menuCopy.setLabel(msgs.get("tree.config.menu.copy"));
        menuCopy.setIcon(request.getContextPath() + "/.resources/icons/16/copy.gif");
        menuCopy.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotRoot(" + tree.getJavascriptTree() + ")");
        menuCopy.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotNodeData(" + tree.getJavascriptTree() + ")");
        menuCopy.setOnclick(tree.getJavascriptTree() + ".copyNode();");
        ContextMenuItem menuCut = new ContextMenuItem("move");
        menuCut.setLabel(msgs.get("tree.config.menu.move"));
        menuCut.setIcon(request.getContextPath() + "/.resources/icons/16/up_down.gif");
        menuCut.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotRoot(" + tree.getJavascriptTree() + ")");
        menuCut.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotNodeData(" + tree.getJavascriptTree() + ")");
        menuCut.setOnclick(tree.getJavascriptTree() + ".cutNode();");
        menuCut.addJavascriptCondition("new mgnlTreeMenuItemConditionPermissionWrite(" + tree.getJavascriptTree() + ")");
        ContextMenuItem menuActivateExcl = new ContextMenuItem("activate");
        menuActivateExcl.setLabel(msgs.get("tree.config.menu.activate"));
        menuActivateExcl.setIcon(request.getContextPath() + "/.resources/icons/16/arrow_right_green.gif");
        menuActivateExcl.setOnclick(tree.getJavascriptTree() + ".activateNode(" + 2 + ",false);");
        menuActivateExcl.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotRoot(" + tree.getJavascriptTree() + ")");
        menuActivateExcl.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotNodeData(" + tree.getJavascriptTree() + ")");
        menuActivateExcl.addJavascriptCondition("new mgnlTreeMenuItemConditionPermissionWrite(" + tree.getJavascriptTree() + ")");
        ContextMenuItem menuActivate = new ContextMenuItem("activateInclSubs");
        menuActivate.setLabel(msgs.get("tree.config.menu.activateInclSubs"));
        menuActivate.setIcon(request.getContextPath() + "/.resources/icons/16/arrow_right_green.gif");
        menuActivate.setOnclick(tree.getJavascriptTree() + ".activateNode(" + 2 + ",true);");
        menuActivate.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotRoot(" + tree.getJavascriptTree() + ")");
        menuActivate.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotNodeData(" + tree.getJavascriptTree() + ")");
        menuActivate.addJavascriptCondition("new mgnlTreeMenuItemConditionPermissionWrite(" + tree.getJavascriptTree() + ")");
        menuActivate.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotItemType(" + tree.getJavascriptTree() + ", '" + PlaylistConstants.PLAYLIST.getSystemName() + "')");
        ContextMenuItem menuDeactivate = new ContextMenuItem("deactivate");
        menuDeactivate.setLabel(msgs.get("tree.config.menu.deactivate"));
        menuDeactivate.setIcon(request.getContextPath() + "/.resources/icons/16/arrow_left_red.gif");
        menuDeactivate.setOnclick(tree.getJavascriptTree() + ".deactivateNode(" + 3 + ");");
        menuDeactivate.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotRoot(" + tree.getJavascriptTree() + ")");
        menuDeactivate.addJavascriptCondition("new mgnlTreeMenuItemConditionSelectedNotNodeData(" + tree.getJavascriptTree() + ")");
        menuDeactivate.addJavascriptCondition("new mgnlTreeMenuItemConditionPermissionWrite(" + tree.getJavascriptTree() + ")");
        if (!this.hasAnyActiveSubscriber()) {
            menuActivateExcl.addJavascriptCondition("new mgnlTreeMenuItemConditionBoolean(false)");
            menuActivate.addJavascriptCondition("new mgnlTreeMenuItemConditionBoolean(false)");
            menuDeactivate.addJavascriptCondition("new mgnlTreeMenuItemConditionBoolean(false)");
        }
        tree.addMenuItem(menuNewFolder);
        tree.addMenuItem(menuNewPlaylist);
        tree.addSeparator();
        tree.addMenuItem(menuDelete);
        tree.addSeparator();
        tree.addMenuItem(menuCut);
        tree.addMenuItem(menuCopy);
        if (!MediaEl.module().isSingleinstance()) {
            tree.addSeparator();
            tree.addMenuItem(menuActivateExcl);
            tree.addMenuItem(menuActivate);
            tree.addMenuItem(menuDeactivate);
        }
    }

    public void prepareFunctionBar(Tree tree, boolean browseMode, HttpServletRequest request) {
        tree.addFunctionBarItem(FunctionBarItem.getRefreshFunctionBarItem((Tree)tree, (Messages)this.getMessages(), (HttpServletRequest)request));
    }

    public void prepareTree(Tree tree, boolean browseMode, HttpServletRequest request) {
        Messages msgs = this.getMessages();
        tree.addItemType(PlaylistConstants.FOLDER.getSystemName(), "/.resources/media/icons/ico16-folder.png");
        tree.addItemType(PlaylistConstants.PLAYLIST.getSystemName(), "/.resources/media/icons/ico16-playlist.png");
        TreeColumn column0 = TreeColumn.createLabelColumn((Tree)tree, (String)msgs.get("tree.playlists.column"), (boolean)true);
        column0.setWidth(3);
        tree.addColumn(column0);
        if (!browseMode && !MediaEl.module().isSingleinstance() && (ServerConfiguration.getInstance().isAdmin() || ActivationManagerFactory.getActivationManager().hasAnyActiveSubscriber())) {
            TreeColumn column1 = TreeColumn.createIconColumn((Tree)tree, (String)msgs.get("tree.config.status"), null);
            column1.setCssClass("");
            column1.setWidth(1);
            column1.setIconsActivation(true);
            column1.setIconsPermission(true);
            tree.addColumn(column1);
        }
    }
}

