/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import org.apache.commons.io.IOUtils;

public final class FLVMedataUtils {
    public static FLVMetaData parseFLVfromStream(InputStream stream) throws IOException {
        return FLVMedataUtils.getMetaData(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FLVMetaData parseFLVfromUrl(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(5000);
        InputStream fis = connection.getInputStream();
        try {
            FLVMetaData fLVMetaData = FLVMedataUtils.parseFLVfromStream(fis);
            return fLVMetaData;
        }
        finally {
            IOUtils.closeQuietly((InputStream)fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FLVMetaData getMetaData(InputStream fis) throws IOException {
        FLVMetaData meta = new FLVMetaData();
        try {
            byte[] bytes = new byte[400];
            fis.read(bytes);
            meta = FLVMedataUtils.getMetaData(bytes);
        }
        finally {
            IOUtils.closeQuietly((InputStream)fis);
        }
        return meta;
    }

    protected static FLVMetaData getMetaData(byte[] bytes) {
        FLVMetaData meta = new FLVMetaData();
        meta.setDuration(FLVMedataUtils.getLong(bytes, "duration"));
        meta.setWidth(FLVMedataUtils.getLong(bytes, "width"));
        meta.setHeight(FLVMedataUtils.getLong(bytes, "height"));
        meta.setAudioDataRate(FLVMedataUtils.getDouble(bytes, "audiodatarate"));
        meta.setVideoDataRate(FLVMedataUtils.getDouble(bytes, "videodatarate"));
        meta.setFileSize(FLVMedataUtils.getLong(bytes, "filesize"));
        meta.setCreatedDate(FLVMedataUtils.getString(bytes, "creationdate"));
        meta.setMimeType(FLVMedataUtils.getString(bytes, "mimetype"));
        meta.setFrameRate(FLVMedataUtils.getDouble(bytes, "framerate"));
        return meta;
    }

    private static double getDouble(byte[] bytes, String property) {
        int offset = FLVMedataUtils.indexOf(bytes, property.getBytes());
        if (offset != -1) {
            return ByteBuffer.wrap(FLVMedataUtils.getBytes(bytes, offset + property.length() + 1, 8)).getDouble();
        }
        return -1.0;
    }

    private static long getLong(byte[] bytes, String property) {
        int offset = FLVMedataUtils.indexOf(bytes, property.getBytes());
        if (offset != -1) {
            return (long)ByteBuffer.wrap(FLVMedataUtils.getBytes(bytes, offset + property.length() + 1, 8)).getDouble();
        }
        return -1L;
    }

    private static String getString(byte[] bytes, String property) {
        int offset = FLVMedataUtils.indexOf(bytes, property.getBytes());
        if (offset != -1) {
            return new String(FLVMedataUtils.getBytes(bytes, offset + property.length() + 3, 24));
        }
        return null;
    }

    private static byte[] getBytes(byte[] bytes, int offset, int length) {
        byte[] requiredBytes = new byte[length];
        int i = offset;
        for (int j = 0; j < length; ++j) {
            requiredBytes[j] = bytes[i];
            ++i;
        }
        return requiredBytes;
    }

    static int indexOf(byte[] source, byte[] target) {
        byte first = target[0];
        int max = source.length - target.length;
        for (int i = 0; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + target.length - 1;
            int k = 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static class FLVMetaData {
        private long duration;
        private long width;
        private long height;
        private double audioDataRate;
        private double videoDataRate;
        private long fileSize;
        private String createdDate;
        private String mimeType;
        private double frameRate;

        public void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        public String getCreatedDate() {
            return this.createdDate;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setWidth(long width) {
            this.width = width;
        }

        public double getWidth() {
            return this.width;
        }

        public void setHeight(long height) {
            this.height = height;
        }

        public long getHeight() {
            return this.height;
        }

        public void setAudioDataRate(double audioDataRate) {
            this.audioDataRate = audioDataRate;
        }

        public double getAudioDataRate() {
            return this.audioDataRate;
        }

        public void setVideoDataRate(double videoDataRate) {
            this.videoDataRate = videoDataRate;
        }

        public double getVideoDataRate() {
            return this.videoDataRate;
        }

        public void setFileSize(long fileSize) {
            this.fileSize = fileSize;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public void setFrameRate(double frameRate) {
            this.frameRate = frameRate;
        }

        public double getFrameRate() {
            return this.frameRate;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }

        public long getDuration() {
            return this.duration;
        }
    }
}

