/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.types.impl;

import info.magnolia.cms.beans.runtime.Document;
import info.magnolia.cms.beans.runtime.MultipartForm;
import info.magnolia.cms.core.Content;
import info.magnolia.module.admininterface.SaveHandlerImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.openutils.mgnlmedia.media.types.externals.ExternalVideoSupport;
import net.sourceforge.openutils.mgnlmedia.media.types.impl.BaseVideoTypeHandler;
import net.sourceforge.openutils.mgnlmedia.media.utils.FLVMedataUtils;
import net.sourceforge.openutils.mgnlmedia.media.utils.RtmpMedatadaFetcher;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalVideoTypeHandler
extends BaseVideoTypeHandler {
    private static final String BASEPATH_ATTRIBUTE = "basepath";
    private final Logger log = LoggerFactory.getLogger(ExternalVideoTypeHandler.class);
    private List<ExternalVideoSupport> videoSupportHandlers = new ArrayList<ExternalVideoSupport>();
    private boolean parseremotefiles;

    public void setParseremotefiles(boolean parseremotefiles) {
        this.parseremotefiles = parseremotefiles;
    }

    @Override
    public void init(Content typeDefinitionNode) {
        super.init(typeDefinitionNode);
    }

    public List<ExternalVideoSupport> getVideoSupportHandlers() {
        return this.videoSupportHandlers;
    }

    public void setVideoSupportHandlers(List<ExternalVideoSupport> videoSupportHandlers) {
        this.videoSupportHandlers = videoSupportHandlers;
    }

    public void addVideoSupportHandlers(ExternalVideoSupport videoSupportHandler) {
        this.videoSupportHandlers.add(videoSupportHandler);
    }

    @Override
    public String getFilename(Content media) {
        return this.getUrl(media);
    }

    @Override
    public String getExtension(Content media) {
        return null;
    }

    @Override
    public void saveFromZipFile(Content media, File f, String cleanFileName, String extension) throws AccessDeniedException, RepositoryException {
    }

    @Override
    public String getUrl(Content media, Map<String, String> options) {
        String basepath;
        String url = media.getNodeData("videoUrl").getString();
        if (!StringUtils.startsWith((String)url, (String)"http") && !StringUtils.startsWith((String)url, (String)"rtmpt") && StringUtils.isNotBlank((String)(basepath = media.getNodeData(BASEPATH_ATTRIBUTE).getString()))) {
            return basepath + url;
        }
        return url;
    }

    @Override
    public String getNewNodeName(MultipartForm form, HttpServletRequest request) {
        String videoUrl = StringUtils.lowerCase((String)request.getParameter("videoUrl"));
        String nodeName = null;
        for (ExternalVideoSupport external : this.videoSupportHandlers) {
            if (!external.isEnabled() || !external.canHandle(videoUrl)) continue;
            nodeName = external.getMediaName(videoUrl);
            break;
        }
        if (StringUtils.isEmpty(nodeName)) {
            if (StringUtils.contains((String)videoUrl, (String)".flv")) {
                nodeName = StringUtils.substringBefore((String)videoUrl, (String)".flv");
                if (StringUtils.contains((String)nodeName, (String)"/")) {
                    nodeName = StringUtils.substringBeforeLast((String)nodeName, (String)"/");
                }
                if (StringUtils.contains((String)nodeName, (String)"=")) {
                    nodeName = StringUtils.substringBeforeLast((String)nodeName, (String)"=");
                }
            } else {
                nodeName = StringUtils.substringBefore((String)StringUtils.substringAfterLast((String)videoUrl, (String)"/"), (String)"?");
            }
        }
        if (StringUtils.isEmpty(nodeName)) {
            nodeName = UUID.randomUUID().toString();
        }
        return nodeName;
    }

    @Override
    protected FLVMedataUtils.FLVMetaData parseFLVMetaData(Content media) throws Exception {
        if (!this.parseremotefiles) {
            return null;
        }
        String downloadUrl = this.getUrl(media);
        for (ExternalVideoSupport external : this.videoSupportHandlers) {
            if (!external.isEnabled() || !external.canHandle(downloadUrl)) continue;
            downloadUrl = external.getFlvUrl(downloadUrl);
            break;
        }
        try {
            if (StringUtils.startsWith((String)downloadUrl, (String)"http")) {
                URL url = new URL(downloadUrl);
                return FLVMedataUtils.parseFLVfromUrl(url);
            }
            if (StringUtils.startsWith((String)downloadUrl, (String)"rtmp")) {
                return RtmpMedatadaFetcher.fetchMetadata(downloadUrl, 10000L);
            }
        }
        catch (IOException e) {
            this.log.warn("Got a " + ClassUtils.getShortClassName(e.getClass()) + " (" + e.getMessage() + ") while parsing URL " + downloadUrl);
        }
        catch (Throwable e) {
            this.log.warn("Got a " + ClassUtils.getShortClassName(e.getClass()) + " (" + e.getMessage() + ") while parsing URL " + downloadUrl, e);
        }
        return null;
    }

    @Override
    public String getUrl(Content media) {
        return this.getUrl(media, null);
    }

    @Override
    public boolean onPostSave(Content media) {
        block5: {
            if (this.parseremotefiles) {
                try {
                    if (media.hasNodeData("image")) break block5;
                    String downloadUrl = this.getUrl(media);
                    for (ExternalVideoSupport external : this.videoSupportHandlers) {
                        if (!external.isEnabled() || !external.canHandle(downloadUrl)) continue;
                        String previewUrl = external.getPreviewUrl(downloadUrl);
                        if (StringUtils.isNotBlank((String)previewUrl)) {
                            this.copyPreviewImageToRepository(media, previewUrl);
                        }
                        break;
                    }
                }
                catch (RepositoryException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return super.onPostSave(media);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void copyPreviewImageToRepository(Content media, String previewUrl) {
        block14: {
            InputStream is = null;
            try {
                HttpURLConnection httpConn;
                URL url;
                block15: {
                    url = new URL(previewUrl);
                    httpConn = (HttpURLConnection)url.openConnection();
                    httpConn.setConnectTimeout(5000);
                    if (httpConn.getResponseCode() != 200) break block15;
                    is = httpConn.getInputStream();
                    File file = File.createTempFile("external-video", "preview");
                    FileOutputStream fout = null;
                    try {
                        fout = new FileOutputStream(file);
                        IOUtils.copy((InputStream)is, (OutputStream)fout);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fout);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)fout);
                    String contentType = httpConn.getContentType();
                    Document doc = new Document(file, contentType);
                    try {
                        SaveHandlerImpl.saveDocument((Content)media, (Document)doc, (String)"image", (String)"preview", null);
                    }
                    catch (RepositoryException e) {
                        this.log.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        doc.delete();
                    }
                }
                this.log.warn("Problem establishing connection with {}: {}", (Object)url, (Object)httpConn.getResponseCode());
                IOUtils.closeQuietly((InputStream)is);
            }
            catch (MalformedURLException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                break block14;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        }
    }
}

