/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.types.impl;

import info.magnolia.cms.beans.runtime.Document;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.NodeData;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.module.admininterface.SaveHandlerImpl;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import javax.jcr.RepositoryException;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.types.impl.BaseTypeHandler;
import net.sourceforge.openutils.mgnlmedia.media.utils.ImageUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.pdfbox.exceptions.WrappedIOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentTypeHandler
extends BaseTypeHandler {
    public static final String PREVIEW_NODEDATA_NAME = "image";
    private static final String METADATA_PAGES = "media_pages";
    private Logger log = LoggerFactory.getLogger(DocumentTypeHandler.class);

    public String getThumbnailUrl(Content media) {
        try {
            if (media == null || !media.hasNodeData(PREVIEW_NODEDATA_NAME) || !ImageUtils.checkOrCreateResolution(media, "thumbnail", PREVIEW_NODEDATA_NAME)) {
                return "/.resources/media/icons/thumb-document.png";
            }
        }
        catch (RepositoryException e) {
            return "/.resources/media/icons/thumb-document.png";
        }
        return MediaConfigurationManager.getInstance().getURIMappingPrefix() + media.getHandle() + "/resolutions/thumbnail/" + media.getName() + "." + ImageUtils.getExtension(media, "thumbnail");
    }

    public String getUrl(Content media) {
        return this.getUrl(media, Collections.<String, String>emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onPostSave(Content media) {
        NodeData data = this.getOriginalFileNodeData(media);
        if (data.getType() == 2 && StringUtils.equalsIgnoreCase((String)data.getAttribute("extension"), (String)"pdf")) {
            String filename = data.getAttribute("fileName") + ".png";
            InputStream stream = data.getStream();
            try {
                this.createPdfPreview(media, stream, filename);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        return super.onPostSave(media);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createPdfPreview(Content media, InputStream stream, String filename) {
        PDDocument document = null;
        try {
            document = PDDocument.load((InputStream)stream);
            List pages = document.getDocumentCatalog().getAllPages();
            NodeDataUtil.getOrCreateAndSet((Content)media, (String)METADATA_PAGES, (int)document.getNumberOfPages());
            if (!pages.isEmpty()) {
                PDPage page = (PDPage)pages.get(0);
                BufferedImage image = page.convertToImage(2, 36);
                File file = File.createTempFile(filename, ".png");
                ImageIO.write((RenderedImage)image, "png", file);
                this.copyPreviewImageToRepository(media, file, filename);
                media.save();
                file.delete();
            }
        }
        catch (NoClassDefFoundError e) {
            this.log.warn("Apache pdfbox 1.0.0 not available, not generating preview for pdf document");
        }
        catch (WrappedIOException e) {
            if (e.getCause() instanceof ClassCastException) {
                this.log.warn("Two conflicting versions of pdfbox are loaded, only one pdfbox jar version 1.x must be loaded in order to make thumbnail generation work. Not generating preview for pdf document");
            } else {
                this.log.error("Error creating preview for " + media.getHandle(), (Throwable)e);
            }
        }
        catch (Throwable e) {
            this.log.error("Error creating preview for " + media.getHandle(), e);
        }
        finally {
            if (document != null) {
                try {
                    document.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyPreviewImageToRepository(Content media, File file, String filename) {
        Document doc = new Document(file, "image/png");
        try {
            SaveHandlerImpl.saveDocument((Content)media, (Document)doc, (String)PREVIEW_NODEDATA_NAME, (String)filename, null);
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            doc.delete();
        }
    }
}

