/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.types.impl;

import info.magnolia.cms.beans.runtime.Document;
import info.magnolia.cms.beans.runtime.FileProperties;
import info.magnolia.cms.beans.runtime.MultipartForm;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.NodeData;
import info.magnolia.cms.i18n.I18nContentSupportFactory;
import info.magnolia.cms.security.AccessDeniedException;
import info.magnolia.module.admininterface.SaveHandlerImpl;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.tags.el.MediaEl;
import net.sourceforge.openutils.mgnlmedia.media.types.MediaTypeHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTypeHandler
implements MediaTypeHandler {
    public static final String ORGINAL_NODEDATA_NAME = "original";
    private Logger log = LoggerFactory.getLogger(BaseTypeHandler.class);
    private String type;

    @Override
    public void init(Content typeDefinitionNode) {
        this.type = typeDefinitionNode.getName();
    }

    @Override
    public String getNewNodeName(MultipartForm form, HttpServletRequest request) {
        return request.getParameter("original_fileName");
    }

    @Override
    public String getPreviewImageNodeDataName() {
        return ORGINAL_NODEDATA_NAME;
    }

    @Override
    public boolean onSavingPropertyMedia(Content media, Content parentNode, Content configNode, String name, HttpServletRequest request, MultipartForm form, int type, int valueType, int isRichEditValue, int encoding) throws RepositoryException, AccessDeniedException {
        String uuid = request.getParameter(name);
        if (!parentNode.hasNodeData(name)) {
            NodeData nd = parentNode.createNodeData(name, (Object)uuid);
        } else {
            NodeData nd = parentNode.getNodeData(name);
            if (nd.getType() == 2) {
                nd.delete();
                nd = parentNode.createNodeData(name, (Object)uuid);
            } else {
                nd.setValue(uuid);
            }
        }
        return true;
    }

    @Override
    public void saveFromZipFile(Content media, File f, String cleanFileName, String extension) throws AccessDeniedException, RepositoryException {
        Document doc = new Document(f, this.type + extension);
        doc.setExtention(extension);
        SaveHandlerImpl.saveDocument((Content)media, (Document)doc, (String)ORGINAL_NODEDATA_NAME, (String)cleanFileName, null);
        this.onPostSave(media);
    }

    @Override
    public boolean onPostSave(Content media) {
        try {
            if (media.hasContent("resolutions")) {
                Collection nodedatas = media.getChildByName("resolutions").getNodeDataCollection();
                for (NodeData nd : nodedatas) {
                    nd.delete();
                }
                media.save();
            }
            if (MediaEl.module().isSingleinstance()) {
                media.getMetaData().setActivated();
                media.save();
            }
        }
        catch (RepositoryException ex) {
            this.log.error("Error removing resolutions", (Throwable)ex);
        }
        return true;
    }

    protected NodeData getOriginalFileNodeData(Content media) {
        return media.getNodeData(ORGINAL_NODEDATA_NAME);
    }

    @Override
    public boolean isExternal(Content media) {
        try {
            return !media.hasNodeData(ORGINAL_NODEDATA_NAME);
        }
        catch (RepositoryException e) {
            this.log.warn("Error testing for external media", (Throwable)e);
            return true;
        }
    }

    @Override
    public String getExtension(Content media) {
        return this.getOriginalFileNodeData(media).getAttribute("extension");
    }

    @Override
    public String getFilename(Content media) {
        return this.getOriginalFileNodeData(media).getAttribute("fileName");
    }

    @Override
    public String getFullFilename(Content media) {
        return this.getFilename(media) + (StringUtils.isNotBlank((String)this.getExtension(media)) ? "." + this.getExtension(media) : "");
    }

    @Override
    public String getUrl(Content media, Map<String, String> options) {
        return MediaConfigurationManager.getInstance().getURIMappingPrefix() + media.getHandle() + "/" + ORGINAL_NODEDATA_NAME + "/" + this.getFullFilename(media);
    }

    @Override
    public String getUrl(Content media) {
        return this.getUrl(media, null);
    }

    @Override
    public String getPreviewUrl(Content media) {
        return this.getUrl(media);
    }

    @Override
    public String getTitle(Content media) {
        return I18nContentSupportFactory.getI18nSupport().getNodeData(media, "title").getString();
    }

    @Override
    public String getTags(Content media) {
        return I18nContentSupportFactory.getI18nSupport().getNodeData(media, "tags").getString();
    }

    @Override
    public String getDescription(Content media) {
        return I18nContentSupportFactory.getI18nSupport().getNodeData(media, "description").getString();
    }

    @Override
    public String getAbstract(Content media) {
        return I18nContentSupportFactory.getI18nSupport().getNodeData(media, "abstract").getString();
    }

    @Override
    public Map<String, String> getMediaInfo(Content media) {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        NodeData originalFileNodeData = this.getOriginalFileNodeData(media);
        if (originalFileNodeData.getType() == 2) {
            int height;
            FileProperties fp = new FileProperties(media, ORGINAL_NODEDATA_NAME);
            String extension = fp.getProperty("extension");
            info.put("media_extension", extension);
            String size = "";
            try {
                size = fp.getProperty("size");
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            info.put("media_size", size);
            int width = NumberUtils.toInt((String)fp.getProperty("width"));
            if (width > 0) {
                info.put("media_width", Integer.toString(width));
            }
            if ((height = NumberUtils.toInt((String)fp.getProperty("height"))) > 0) {
                info.put("media_height", Integer.toString(height));
            }
        }
        Collection propertyList = media.getNodeDataCollection("media_*");
        for (NodeData property : propertyList) {
            this.addToInfo(media, info, property.getName());
        }
        return info;
    }

    protected void addToInfo(Content media, Map<String, String> info, String key) {
        NodeData data = media.getNodeData(key);
        String string = null;
        if (data.getType() == 3 || data.getType() == 4) {
            int numeric = (int)data.getLong();
            if (numeric > 0) {
                string = String.valueOf(numeric);
            }
        } else {
            string = data.getString();
        }
        if (StringUtils.isNotEmpty((String)string)) {
            info.put(key, string);
        }
    }
}

