/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.types.externals;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import net.sourceforge.openutils.mgnlmedia.media.types.externals.ExternalVideoSupport;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeSupport
implements ExternalVideoSupport {
    private Logger log = LoggerFactory.getLogger(YoutubeSupport.class);
    private boolean enabled = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean canHandle(String url) {
        return StringUtils.startsWith((String)url, (String)"http://www.youtube");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFlvUrl(String shareUrl) {
        String flvUrl;
        block8: {
            flvUrl = null;
            BufferedReader in = null;
            try {
                String line;
                String videoId = this.getVideoId(shareUrl);
                String videoInfoUrl = "http://www.youtube.com/get_video_info?video_id=" + videoId;
                URL url = new URL(videoInfoUrl);
                HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
                httpConn.setConnectTimeout(5000);
                if (httpConn.getResponseCode() != 200) break block8;
                in = new BufferedReader(new InputStreamReader(httpConn.getInputStream()));
                String search = "&token=";
                while ((line = in.readLine()) != null) {
                    int p = line.indexOf(search);
                    if (p == -1) continue;
                    String token = StringUtils.substringBefore((String)line.substring(p + search.length()), (String)"&");
                    flvUrl = "http://www.youtube.com/get_video?fmt=5&video_id=" + videoId + "&t=" + token;
                    break;
                }
            }
            catch (MalformedURLException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
        return flvUrl;
    }

    public String getPreviewUrl(String shareUrl) {
        return "http://img.youtube.com/vi/" + this.getVideoId(shareUrl) + "/0.jpg";
    }

    public String getMediaName(String shareUrl) {
        return this.getVideoId(shareUrl);
    }

    private String getVideoId(String shareUrl) {
        for (String att : StringUtils.split((String)StringUtils.substringAfter((String)shareUrl, (String)"?"), (String)"&")) {
            if (!att.startsWith("v=")) continue;
            return StringUtils.substringAfter((String)att, (String)"v=");
        }
        return null;
    }
}

