/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.setup;

import info.magnolia.cms.beans.config.ContentRepository;
import info.magnolia.cms.security.Role;
import info.magnolia.cms.security.Security;
import info.magnolia.importexport.Bootstrapper;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractTask;
import info.magnolia.module.delta.TaskExecutionException;
import info.magnolia.module.model.ModuleDefinition;
import info.magnolia.module.model.RepositoryDefinition;
import java.util.Collection;
import java.util.List;

public class SetupModuleRepositoriesWithoutSubscriberTask
extends AbstractTask {
    public SetupModuleRepositoriesWithoutSubscriberTask() {
        super("Setup module repositories", "Bootstrap empty repositories and grant them to superuser.");
    }

    public void execute(InstallContext ctx) throws TaskExecutionException {
        try {
            ModuleDefinition def = ctx.getCurrentModuleDefinition();
            Collection repositories = def.getRepositories();
            for (RepositoryDefinition repDef : repositories) {
                List workspaces = repDef.getWorkspaces();
                for (final String workspace : workspaces) {
                    if (!ContentRepository.checkIfInitialized((String)workspace)) {
                        String[] bootstrapDirs = Bootstrapper.getBootstrapDirs();
                        Bootstrapper.bootstrapRepository((String[])bootstrapDirs, (String)workspace, (Bootstrapper.BootstrapFilter)new Bootstrapper.BootstrapFilter(){

                            public boolean accept(String filename) {
                                return filename.startsWith(workspace + ".");
                            }
                        });
                    }
                    this.grantRepositoryToSuperuser(workspace);
                }
            }
        }
        catch (Throwable e) {
            throw new TaskExecutionException("Could not bootstrap workspace: " + e.getMessage(), e);
        }
    }

    private void grantRepositoryToSuperuser(String workspace) {
        Role superuser = Security.getRoleManager().getRole("superuser");
        superuser.addPermission(workspace, "/*", 63L);
    }
}

