/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.setup;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.NodeData;
import info.magnolia.cms.core.search.Query;
import info.magnolia.cms.core.search.QueryManager;
import info.magnolia.cms.core.search.QueryResult;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractTask;
import info.magnolia.module.delta.TaskExecutionException;
import java.util.Collection;
import javax.jcr.RepositoryException;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;

public class RenameThumbToImageTask
extends AbstractTask {
    public RenameThumbToImageTask() {
        super("Rename thumbnail to image", "Rename thumbnail nodedata to image nodedata for media");
    }

    public void execute(InstallContext installContext) throws TaskExecutionException {
        HierarchyManager hm = installContext.getHierarchyManager("media");
        QueryManager mgr = hm.getQueryManager();
        try {
            Query query = mgr.createQuery("//*", "xpath");
            QueryResult result = query.execute();
            Collection medias = result.getContent(MediaConfigurationManager.MEDIA.getSystemName());
            for (Content node : medias) {
                NodeData thumbnail;
                if (!node.hasNodeData("thumbnail") || (thumbnail = node.getNodeData("thumbnail")).getType() != 2) continue;
                NodeData image = node.createNodeData("image", 2);
                image.setValue(thumbnail.getStream());
                image.setAttribute("extension", thumbnail.getAttribute("extension"));
                image.setAttribute("fileName", thumbnail.getAttribute("fileName"));
                image.setAttribute("jcr:mimeType", thumbnail.getAttribute("jcr:mimeType"));
                image.setAttribute("jcr:lastModified", thumbnail.getAttribute("jcr:lastModified"));
                image.setAttribute("width", thumbnail.getAttribute("width"));
                image.setAttribute("height", thumbnail.getAttribute("height"));
                thumbnail.delete();
            }
            hm.save();
        }
        catch (RepositoryException ex) {
            throw new TaskExecutionException(ex.getMessage(), (Throwable)ex);
        }
    }
}

